/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntitiesDescriptorType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.exportimport.ClientDescriptionConverter;
import org.keycloak.exportimport.ClientDescriptionConverterFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.util.SAMLMetadataUtil;

public class EntityDescriptorDescriptionConverter
implements ClientDescriptionConverter,
ClientDescriptionConverterFactory {
    public static final String ID = "saml2-entity-descriptor";

    @Override
    public boolean isSupported(String description) {
        return (description = description.trim()).startsWith("<") && description.endsWith(">") && description.contains("EntityDescriptor");
    }

    @Override
    public ClientRepresentation convertToInternal(String description) {
        return EntityDescriptorDescriptionConverter.loadEntityDescriptors(new ByteArrayInputStream(description.getBytes()));
    }

    public static SPSSODescriptorType getSPDescriptor(EntityDescriptorType entityDescriptor) {
        return entityDescriptor.getChoiceType().stream().flatMap(d -> d.getDescriptors().stream()).map(EntityDescriptorType.EDTDescriptorChoiceType::getSpDescriptor).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static String getServiceURL(SPSSODescriptorType sp, String bindingURI) {
        List endpoints = sp.getAssertionConsumerService();
        for (IndexedEndpointType endpoint : endpoints) {
            if (!Objects.equals(endpoint.getBinding().toString(), bindingURI)) continue;
            return endpoint.getLocation().toString();
        }
        return null;
    }

    private static String getArtifactResolutionService(SPSSODescriptorType sp, int index) {
        List endpoints = sp.getArtifactResolutionService();
        for (IndexedEndpointType endpoint : endpoints) {
            if (endpoint.getIndex() != index) continue;
            return endpoint.getLocation().toString();
        }
        return null;
    }

    private static String getArtifactResolutionService(SPSSODescriptorType sp) {
        List endpoints = sp.getArtifactResolutionService();
        IndexedEndpointType firstEndpoint = null;
        for (IndexedEndpointType endpoint : endpoints) {
            if (endpoint.isIsDefault() != null && endpoint.isIsDefault().booleanValue()) {
                firstEndpoint = endpoint;
                break;
            }
            if (firstEndpoint != null && endpoint.getIndex() >= firstEndpoint.getIndex()) continue;
            firstEndpoint = endpoint;
        }
        if (firstEndpoint != null) {
            return firstEndpoint.getLocation().toString();
        }
        return null;
    }

    private static ClientRepresentation loadEntityDescriptors(InputStream is) {
        String artifactResolutionService;
        String assertionConsumerServiceArtifactBinding;
        String assertionConsumerServicePaosBinding;
        String assertionConsumerServiceSoapBinding;
        String assertionConsumerServiceRedirectBinding;
        String assertionConsumerServicePostBinding;
        String logoutRedirect;
        String logoutPost;
        EntitiesDescriptorType entities;
        Object metadata;
        try {
            metadata = SAMLParser.getInstance().parse(is);
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
        if (EntitiesDescriptorType.class.isInstance(metadata)) {
            entities = (EntitiesDescriptorType)metadata;
        } else {
            entities = new EntitiesDescriptorType();
            entities.addEntityDescriptor(metadata);
        }
        if (entities.getEntityDescriptor().size() != 1) {
            throw new RuntimeException("Expected one entity descriptor");
        }
        EntityDescriptorType entity = (EntityDescriptorType)entities.getEntityDescriptor().get(0);
        String entityId = entity.getEntityID();
        ClientRepresentation app = new ClientRepresentation();
        app.setClientId(entityId);
        HashMap<String, String> attributes = new HashMap<String, String>();
        app.setAttributes(attributes);
        LinkedList<String> redirectUris = new LinkedList<String>();
        app.setRedirectUris(redirectUris);
        app.setFullScopeAllowed(Boolean.valueOf(true));
        app.setProtocol("saml");
        attributes.put("saml.server.signature", "true");
        attributes.put("saml.server.signature.keyinfo.ext", "false");
        attributes.put("saml.signature.algorithm", SignatureAlgorithm.RSA_SHA256.toString());
        attributes.put("saml.authnstatement", "true");
        SPSSODescriptorType spDescriptorType = EntityDescriptorDescriptionConverter.getSPDescriptor(entity);
        if (spDescriptorType.isWantAssertionsSigned().booleanValue()) {
            attributes.put("saml.assertion.signature", "true");
        }
        if ((logoutPost = EntityDescriptorDescriptionConverter.getLogoutLocation(spDescriptorType, JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get())) != null) {
            attributes.put("saml_single_logout_service_url_post", logoutPost);
        }
        if ((logoutRedirect = EntityDescriptorDescriptionConverter.getLogoutLocation(spDescriptorType, JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get())) != null) {
            attributes.put("saml_single_logout_service_url_redirect", logoutRedirect);
        }
        if ((assertionConsumerServicePostBinding = EntityDescriptorDescriptionConverter.getServiceURL(spDescriptorType, JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get())) != null) {
            attributes.put("saml_assertion_consumer_url_post", assertionConsumerServicePostBinding);
            redirectUris.add(assertionConsumerServicePostBinding);
        }
        if ((assertionConsumerServiceRedirectBinding = EntityDescriptorDescriptionConverter.getServiceURL(spDescriptorType, JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get())) != null) {
            attributes.put("saml_assertion_consumer_url_redirect", assertionConsumerServiceRedirectBinding);
            redirectUris.add(assertionConsumerServiceRedirectBinding);
        }
        if ((assertionConsumerServiceSoapBinding = EntityDescriptorDescriptionConverter.getServiceURL(spDescriptorType, JBossSAMLURIConstants.SAML_SOAP_BINDING.get())) != null) {
            redirectUris.add(assertionConsumerServiceSoapBinding);
        }
        if ((assertionConsumerServicePaosBinding = EntityDescriptorDescriptionConverter.getServiceURL(spDescriptorType, JBossSAMLURIConstants.SAML_PAOS_BINDING.get())) != null) {
            redirectUris.add(assertionConsumerServicePaosBinding);
        }
        if ((assertionConsumerServiceArtifactBinding = EntityDescriptorDescriptionConverter.getServiceURL(spDescriptorType, JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.get())) != null) {
            attributes.put("saml_artifact_binding_url", assertionConsumerServiceArtifactBinding);
            redirectUris.add(assertionConsumerServiceArtifactBinding);
        }
        if ((artifactResolutionService = EntityDescriptorDescriptionConverter.getArtifactResolutionService(spDescriptorType)) != null) {
            attributes.put("saml_artifact_resolution_service_url", artifactResolutionService);
        }
        if (spDescriptorType.getNameIDFormat() != null) {
            for (String format : spDescriptorType.getNameIDFormat()) {
                String attribute = SamlClient.samlNameIDFormatToClientAttribute(format);
                if (attribute == null) continue;
                attributes.put("saml_name_id_format", attribute);
                break;
            }
        }
        app.setProtocolMappers(spDescriptorType.getAttributeConsumingService().stream().flatMap(att -> att.getRequestedAttribute().stream()).map(attr -> {
            ProtocolMapperRepresentation mapper = new ProtocolMapperRepresentation();
            mapper.setName(attr.getName());
            mapper.setProtocol("saml");
            mapper.setProtocolMapper("saml-user-attribute-mapper");
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("attribute.name", attr.getName());
            if (attr.getFriendlyName() != null) {
                config.put("friendly.name", attr.getFriendlyName());
            }
            if (attr.getNameFormat() != null) {
                config.put("attribute.nameformat", EntityDescriptorDescriptionConverter.getSAMLNameFormat(attr.getNameFormat()));
            }
            mapper.setConfig(config);
            return mapper;
        }).collect(Collectors.toList()));
        for (KeyDescriptorType keyDescriptor : spDescriptorType.getKeyDescriptor()) {
            X509Certificate cert = null;
            try {
                cert = SAMLMetadataUtil.getCertificate((KeyDescriptorType)keyDescriptor);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (ProcessingException e) {
                throw new RuntimeException(e);
            }
            String certPem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)cert);
            if (keyDescriptor.getUse() == KeyTypes.SIGNING) {
                attributes.put("saml.client.signature", "true");
                attributes.put("saml.signing.certificate", certPem);
                continue;
            }
            if (keyDescriptor.getUse() != KeyTypes.ENCRYPTION) continue;
            attributes.put("saml.encrypt", "true");
            attributes.put("saml.encryption.certificate", certPem);
        }
        return app;
    }

    private static String getSAMLNameFormat(String xmlValue) {
        String value = null;
        if (JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.getUri().toString().equals(xmlValue)) {
            value = "URI Reference";
        } else if (JBossSAMLURIConstants.ATTRIBUTE_FORMAT_BASIC.getUri().toString().equals(xmlValue)) {
            value = "Basic";
        } else if (JBossSAMLURIConstants.ATTRIBUTE_FORMAT_UNSPECIFIED.getUri().toString().equals(xmlValue)) {
            value = "Unspecified";
        }
        return value;
    }

    private static String getLogoutLocation(SPSSODescriptorType idp, String bindingURI) {
        String logoutResponseLocation = null;
        List endpoints = idp.getSingleLogoutService();
        for (EndpointType endpoint : endpoints) {
            if (!endpoint.getBinding().toString().equals(bindingURI)) continue;
            if (endpoint.getLocation() != null) {
                logoutResponseLocation = endpoint.getLocation().toString();
                break;
            }
            logoutResponseLocation = null;
            break;
        }
        return logoutResponseLocation;
    }

    public ClientDescriptionConverter create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

