/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionConfiguration;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.context.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.context.AdminClientUpdateContext;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.context.DynamicClientRegisterContext;
import org.keycloak.services.clientpolicy.context.DynamicClientUpdateContext;

public class ClientUpdateSourceRolesCondition
implements ClientPolicyConditionProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(ClientUpdateSourceRolesCondition.class);
    private Configuration configuration = new Configuration();
    private final KeycloakSession session;

    public ClientUpdateSourceRolesCondition(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public boolean isNegativeLogic() {
        return Optional.ofNullable(this.configuration.isNegativeLogic()).orElse(Boolean.FALSE);
    }

    public String getProviderId() {
        return "clientupdatesourceroles-condition";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: {
                if (context instanceof AdminClientRegisterContext) {
                    return this.getVoteForRolesMatched(((ClientCRUDContext)context).getAuthenticatedUser());
                }
                if (context instanceof DynamicClientRegisterContext) {
                    return this.getVoteForRolesMatched(((ClientCRUDContext)context).getToken());
                }
                throw new ClientPolicyException("server_error", "unexpected context type.");
            }
            case UPDATE: {
                if (context instanceof AdminClientUpdateContext) {
                    return this.getVoteForRolesMatched(((ClientCRUDContext)context).getAuthenticatedUser());
                }
                if (context instanceof DynamicClientUpdateContext) {
                    return this.getVoteForRolesMatched(((ClientCRUDContext)context).getToken());
                }
                throw new ClientPolicyException("server_error", "unexpected context type.");
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private ClientPolicyVote getVoteForRolesMatched(UserModel user) {
        if (this.isRolesMatched(user)) {
            return ClientPolicyVote.YES;
        }
        return ClientPolicyVote.NO;
    }

    private ClientPolicyVote getVoteForRolesMatched(JsonWebToken token) {
        if (token == null) {
            return ClientPolicyVote.NO;
        }
        if (this.isRoleMatched(token.getSubject())) {
            return ClientPolicyVote.YES;
        }
        return ClientPolicyVote.NO;
    }

    private boolean isRoleMatched(String subjectId) {
        if (subjectId == null) {
            return false;
        }
        return this.isRolesMatched(this.session.users().getUserById(this.session.getContext().getRealm(), subjectId));
    }

    private boolean isRolesMatched(UserModel user) {
        if (user == null) {
            return false;
        }
        Set<String> expectedRoles = this.instantiateRolesForMatching();
        if (expectedRoles == null) {
            return false;
        }
        Set<String> roles = user.getRoleMappingsStream().map(RoleModel::getName).collect(Collectors.toSet());
        if (logger.isTraceEnabled()) {
            roles.forEach(i -> logger.tracev("user role = {0}", i));
            expectedRoles.forEach(i -> logger.tracev("roles expected = {0}", i));
        }
        RealmModel realm = this.session.getContext().getRealm();
        boolean isMatched = expectedRoles.stream().anyMatch(i -> {
            if (realm.getRole(i) != null && user.hasRole(realm.getRole(i))) {
                return true;
            }
            return realm.getClientsStream().anyMatch(j -> j.getRole(i) != null && user.hasRole(j.getRole(i)));
        });
        return isMatched;
    }

    private Set<String> instantiateRolesForMatching() {
        List<String> roles = this.configuration.getRoles();
        if (roles == null) {
            return null;
        }
        return new HashSet<String>(roles);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Configuration
    extends ClientPolicyConditionConfiguration {
        @JsonProperty(value="is-negative-logic")
        protected Boolean negativeLogic;
        protected List<String> roles;

        public Boolean isNegativeLogic() {
            return this.negativeLogic;
        }

        public void setNegativeLogic(Boolean negativeLogic) {
            this.negativeLogic = negativeLogic;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }
    }
}

