/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.common.util.SystemEnvProperties;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ThemeManager;
import org.keycloak.theme.DefaultThemeManagerFactory;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;
import org.keycloak.theme.ThemeResourceProvider;
import org.keycloak.theme.ThemeSelectorProvider;

public class DefaultThemeManager
implements ThemeManager {
    private static final Logger log = Logger.getLogger(DefaultThemeManager.class);
    private final DefaultThemeManagerFactory factory;
    private final KeycloakSession session;
    private List<ThemeProvider> providers;
    private String defaultTheme;

    public DefaultThemeManager(DefaultThemeManagerFactory factory, KeycloakSession session) {
        this.factory = factory;
        this.session = session;
        this.defaultTheme = Config.scope((String[])new String[]{"theme"}).get("default", Version.NAME.toLowerCase());
    }

    public Theme getTheme(Theme.Type type) {
        String name = ((ThemeSelectorProvider)this.session.getProvider(ThemeSelectorProvider.class)).getThemeName(type);
        return this.getTheme(name, type);
    }

    private String typeBasedDefault(Theme.Type type) {
        if (type == Theme.Type.ACCOUNT && DefaultThemeManager.isAccount2Enabled()) {
            return "keycloak.v2";
        }
        return "keycloak";
    }

    public Theme getTheme(String name, Theme.Type type) {
        Theme theme;
        if (name == null) {
            name = this.defaultTheme;
        }
        if ((theme = this.factory.getCachedTheme(name, type)) == null) {
            theme = this.loadTheme(name, type);
            if (theme == null) {
                theme = this.loadTheme(this.typeBasedDefault(type), type);
                if (theme == null) {
                    theme = this.loadTheme("base", type);
                }
                log.errorv("Failed to find {0} theme {1}, using built-in themes", (Object)type, (Object)name);
            } else {
                theme = this.factory.addCachedTheme(name, type, theme);
            }
        }
        if (!DefaultThemeManager.isAccount2Enabled() && theme.getName().equals("keycloak.v2")) {
            theme = this.loadTheme("keycloak", type);
        }
        if (!DefaultThemeManager.isAccount2Enabled() && theme.getName().equals("rhsso.v2")) {
            theme = this.loadTheme("rhsso", type);
        }
        return theme;
    }

    public Set<String> nameSet(Theme.Type type) {
        HashSet<String> themes = new HashSet<String>();
        for (ThemeProvider p : this.getProviders()) {
            themes.addAll(p.nameSet(type));
        }
        return themes;
    }

    public boolean isCacheEnabled() {
        return this.factory.isCacheEnabled();
    }

    public void clearCache() {
        this.factory.clearCache();
    }

    private Theme loadTheme(String name, Theme.Type type) {
        Theme theme = this.findTheme(name, type);
        if (theme == null) {
            return null;
        }
        LinkedList<Theme> themes = new LinkedList<Theme>();
        themes.add(theme);
        if (theme.getImportName() != null) {
            String[] s = theme.getImportName().split("/");
            themes.add(this.findTheme(s[1], Theme.Type.valueOf((String)s[0].toUpperCase())));
        }
        if (theme.getParentName() != null) {
            String parentName = theme.getParentName();
            while (parentName != null) {
                theme = this.findTheme(parentName, type);
                themes.add(theme);
                if (theme.getImportName() != null) {
                    String[] s = theme.getImportName().split("/");
                    themes.add(this.findTheme(s[1], Theme.Type.valueOf((String)s[0].toUpperCase())));
                }
                parentName = theme.getParentName();
            }
        }
        return new ExtendingTheme(themes, this.session.getAllProviders(ThemeResourceProvider.class));
    }

    private Theme findTheme(String name, Theme.Type type) {
        for (ThemeProvider p : this.getProviders()) {
            if (!p.hasTheme(name, type)) continue;
            try {
                return p.getTheme(name, type);
            }
            catch (IOException e) {
                log.errorv((Throwable)e, p.getClass() + " failed to load theme, type={0}, name={1}", (Object)type, (Object)name);
            }
        }
        return null;
    }

    private static Locale getParent(Locale locale) {
        if (Locale.ENGLISH.equals(locale)) {
            return null;
        }
        if (locale.getVariant() != null && !locale.getVariant().isEmpty()) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry() != null && !locale.getCountry().isEmpty()) {
            return new Locale(locale.getLanguage());
        }
        return Locale.ENGLISH;
    }

    private List<ThemeProvider> getProviders() {
        if (this.providers == null) {
            this.providers = new LinkedList<ThemeProvider>(this.session.getAllProviders(ThemeProvider.class));
            Collections.sort(this.providers, (o1, o2) -> o2.getProviderPriority() - o1.getProviderPriority());
        }
        return this.providers;
    }

    private static boolean isAccount2Enabled() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ACCOUNT2);
    }

    private static class ExtendingTheme
    implements Theme {
        private List<Theme> themes;
        private Set<ThemeResourceProvider> themeResourceProviders;
        private Properties properties;
        private ConcurrentHashMap<String, ConcurrentHashMap<Locale, Properties>> messages = new ConcurrentHashMap();

        public ExtendingTheme(List<Theme> themes, Set<ThemeResourceProvider> themeResourceProviders) {
            this.themes = themes;
            this.themeResourceProviders = themeResourceProviders;
        }

        public String getName() {
            return this.themes.get(0).getName();
        }

        public String getParentName() {
            return this.themes.get(0).getParentName();
        }

        public String getImportName() {
            return this.themes.get(0).getImportName();
        }

        public Theme.Type getType() {
            return this.themes.get(0).getType();
        }

        public URL getTemplate(String name) throws IOException {
            URL template;
            for (Theme theme : this.themes) {
                template = theme.getTemplate(name);
                if (template == null) continue;
                return template;
            }
            for (ThemeResourceProvider themeResourceProvider : this.themeResourceProviders) {
                template = themeResourceProvider.getTemplate(name);
                if (template == null) continue;
                return template;
            }
            return null;
        }

        public InputStream getResourceAsStream(String path) throws IOException {
            InputStream resource;
            for (Theme theme : this.themes) {
                resource = theme.getResourceAsStream(path);
                if (resource == null) continue;
                return resource;
            }
            for (ThemeResourceProvider themeResourceProvider : this.themeResourceProviders) {
                resource = themeResourceProvider.getResourceAsStream(path);
                if (resource == null) continue;
                return resource;
            }
            return null;
        }

        public Properties getMessages(Locale locale) throws IOException {
            return this.getMessages("messages", locale);
        }

        public Properties getMessages(String baseBundlename, Locale locale) throws IOException {
            if (this.messages.get(baseBundlename) == null || this.messages.get(baseBundlename).get(locale) == null) {
                Properties messages = new Properties();
                Locale parent = DefaultThemeManager.getParent(locale);
                if (parent != null) {
                    messages.putAll((Map<?, ?>)this.getMessages(baseBundlename, parent));
                }
                for (ThemeResourceProvider t : this.themeResourceProviders) {
                    messages.putAll((Map<?, ?>)t.getMessages(baseBundlename, locale));
                }
                ListIterator<Theme> itr = this.themes.listIterator(this.themes.size());
                while (itr.hasPrevious()) {
                    Properties m = itr.previous().getMessages(baseBundlename, locale);
                    if (m == null) continue;
                    messages.putAll((Map<?, ?>)m);
                }
                this.messages.putIfAbsent(baseBundlename, new ConcurrentHashMap());
                this.messages.get(baseBundlename).putIfAbsent(locale, messages);
                return messages;
            }
            return this.messages.get(baseBundlename).get(locale);
        }

        public Properties getProperties() throws IOException {
            if (this.properties == null) {
                Properties properties = new Properties();
                ListIterator<Theme> itr = this.themes.listIterator(this.themes.size());
                while (itr.hasPrevious()) {
                    Properties p = itr.previous().getProperties();
                    if (p == null) continue;
                    properties.putAll((Map<?, ?>)p);
                }
                this.substituteProperties(properties);
                this.properties = properties;
                return properties;
            }
            return this.properties;
        }

        private void substituteProperties(Properties properties) {
            for (String propertyName : properties.stringPropertyNames()) {
                properties.setProperty(propertyName, StringPropertyReplacer.replaceProperties((String)properties.getProperty(propertyName), (Properties)new SystemEnvProperties()));
            }
        }
    }
}

