/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.mock;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.plugins.server.BaseHttpRequest;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.NotImplementedYetException;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.RunnableWithException;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.ReadFromStream;

public class MockHttpRequest
extends BaseHttpRequest {
    protected ResteasyHttpHeaders httpHeaders;
    protected InputStream inputStream;
    protected String httpMethod;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected ResteasyAsynchronousContext asynchronousContext;
    protected static final URI EMPTY_URI = URI.create("");

    protected MockHttpRequest() {
        super(null);
    }

    protected static MockHttpRequest initWithUri(String uri) throws URISyntaxException {
        URI absoluteUri = new URI(uri);
        URI baseUri = EMPTY_URI;
        return MockHttpRequest.initWithUri(absoluteUri, baseUri);
    }

    public static MockHttpRequest create(String httpMethod, String absolute, String query, String contextPath) {
        MockHttpRequest request = new MockHttpRequest();
        request.httpHeaders = new ResteasyHttpHeaders(new CaseInsensitiveMap<String>());
        if (query != null && query.length() > 0) {
            absolute = absolute + "?" + query;
        }
        request.uri = new ResteasyUriInfo(absolute, contextPath);
        request.httpMethod = httpMethod;
        return request;
    }

    private static MockHttpRequest initWithUri(URI absoluteUri, URI baseUri) {
        if (baseUri == null) {
            baseUri = EMPTY_URI;
        }
        MockHttpRequest request = new MockHttpRequest();
        request.httpHeaders = new ResteasyHttpHeaders(new CaseInsensitiveMap<String>());
        request.uri = new ResteasyUriInfo(absoluteUri.toString(), baseUri.getRawPath());
        return request;
    }

    public static MockHttpRequest create(String httpMethod, String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = httpMethod;
        return request;
    }

    public static MockHttpRequest create(String httpMethod, URI uriObj, URI baseUri) {
        MockHttpRequest request = MockHttpRequest.initWithUri(uriObj, baseUri);
        request.httpMethod = httpMethod;
        return request;
    }

    public static MockHttpRequest options(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "OPTIONS";
        return request;
    }

    public static MockHttpRequest get(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "GET";
        return request;
    }

    public static MockHttpRequest post(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "POST";
        return request;
    }

    public static MockHttpRequest put(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "PUT";
        return request;
    }

    public static MockHttpRequest delete(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "DELETE";
        return request;
    }

    public static MockHttpRequest head(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "HEAD";
        return request;
    }

    public static MockHttpRequest deepCopy(HttpRequest request) throws IOException {
        MockHttpRequest mock = new MockHttpRequest();
        mock.uri = (ResteasyUriInfo)request.getUri();
        mock.httpHeaders = (ResteasyHttpHeaders)request.getHttpHeaders();
        mock.httpMethod = request.getHttpMethod();
        byte[] bytes = ReadFromStream.readFromStream(1024, request.getInputStream());
        mock.inputStream = new ByteArrayInputStream(bytes);
        return mock;
    }

    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    public ResteasyAsynchronousContext getAsynchronousContext() {
        return this.asynchronousContext;
    }

    public void setAsynchronousContext(ResteasyAsynchronousContext asynchronousContext) {
        this.asynchronousContext = asynchronousContext;
    }

    public MockHttpRequest header(String name, String value) {
        this.httpHeaders.getMutableHeaders().add((Object)name, (Object)value);
        return this;
    }

    public MockHttpRequest accept(List<MediaType> accepts) {
        for (MediaType accept : accepts) {
            this.accept(accept);
        }
        return this;
    }

    public MockHttpRequest accept(MediaType accept) {
        this.httpHeaders.getMutableHeaders().add((Object)"Accept", (Object)accept.toString());
        return this;
    }

    public MockHttpRequest accept(String type) {
        this.httpHeaders.getMutableHeaders().add((Object)"Accept", (Object)type);
        return this;
    }

    public MockHttpRequest language(String language) {
        this.httpHeaders.getMutableHeaders().add((Object)"Accept-Language", (Object)language);
        return this;
    }

    public MockHttpRequest cookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        this.httpHeaders.getMutableCookies().put(name, cookie);
        return this;
    }

    public MockHttpRequest contentType(String type) {
        this.httpHeaders.getMutableHeaders().add((Object)"Content-Type", (Object)type);
        return this;
    }

    public MockHttpRequest contentType(MediaType type) {
        if (type == null) {
            this.httpHeaders.getMutableHeaders().remove((Object)"Content-Type");
            return this;
        }
        this.httpHeaders.getMutableHeaders().add((Object)"Content-Type", (Object)type.toString());
        return this;
    }

    public MockHttpRequest content(byte[] bytes) {
        this.inputStream = new ByteArrayInputStream(bytes);
        return this;
    }

    public MockHttpRequest content(InputStream stream) {
        this.inputStream = stream;
        return this;
    }

    public MockHttpRequest addFormHeader(String name, String value) {
        if (this.decodedFormParameters == null) {
            this.decodedFormParameters = new MultivaluedMapImpl();
            this.contentType("application/x-www-form-urlencoded");
        }
        this.decodedFormParameters.add((Object)name, (Object)value);
        return this;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.httpHeaders.getMutableHeaders();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream stream) {
        this.inputStream = stream;
    }

    @Override
    public ResteasyUriInfo getUri() {
        return this.uri;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void initialRequestThreadFinished() {
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration<String> en = new Enumeration<String>(){
            private Iterator<String> it;
            {
                this.it = MockHttpRequest.this.attributes.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public String nextElement() {
                return this.it.next();
            }
        };
        return en;
    }

    public ResteasyAsynchronousContext getAsyncContext() {
        if (this.asynchronousContext != null) {
            return this.asynchronousContext;
        }
        return new ResteasyAsynchronousContext(){

            public boolean isSuspended() {
                return false;
            }

            public ResteasyAsynchronousResponse getAsyncResponse() {
                return null;
            }

            public ResteasyAsynchronousResponse suspend() throws IllegalStateException {
                return null;
            }

            public ResteasyAsynchronousResponse suspend(long millis) throws IllegalStateException {
                return null;
            }

            public ResteasyAsynchronousResponse suspend(long time, TimeUnit unit) throws IllegalStateException {
                return null;
            }

            public void complete() {
            }

            public void initialRequestStarted() {
            }

            public void initialRequestEnded() {
            }

            public boolean isOnInitialRequest() {
                return true;
            }

            public CompletionStage<Void> executeBlockingIo(RunnableWithException f, boolean hasInterceptors) {
                CompletableFuture<Void> ret = new CompletableFuture<Void>();
                try {
                    f.run();
                    ret.complete(null);
                }
                catch (Exception e) {
                    ret.completeExceptionally(e);
                }
                return ret;
            }

            public CompletionStage<Void> executeAsyncIo(CompletionStage<Void> f) {
                return f;
            }
        };
    }

    public void forward(String path) {
        throw new NotImplementedYetException();
    }

    public boolean wasForwarded() {
        return false;
    }

    public String getRemoteHost() {
        return null;
    }

    public String getRemoteAddress() {
        return null;
    }
}

