/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.deployment;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.logging.Logger;
import org.keycloak.util.Environment;

public class BuildClassLoader
extends URLClassLoader {
    private static final Logger logger = Logger.getLogger(BuildClassLoader.class);

    public BuildClassLoader() {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
        String homeDir = Environment.getHomeDir();
        if (homeDir == null) {
            return;
        }
        File providersDir = new File(homeDir + File.separator + "providers");
        if (providersDir.isDirectory()) {
            for (File file : providersDir.listFiles(new JarFilter())) {
                try {
                    this.addURL(file.toURI().toURL());
                    logger.debug((Object)("Loading providers from " + file.getAbsolutePath()));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Failed to add provider JAR at " + file.getAbsolutePath());
                }
            }
        }
    }

    class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    }
}

