/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import java.lang.reflect.Modifier;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.dynamic.DynamicType;
import org.hibernate.bytecode.internal.bytebuddy.BytecodeProviderImpl;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyProxyHelper;

final class ProxyBuildingHelper
implements AutoCloseable {
    private final ClassLoader contextClassLoader;
    private ByteBuddyProxyHelper byteBuddyProxyHelper;
    private BytecodeProviderImpl bytecodeProvider;

    public ProxyBuildingHelper(ClassLoader contextClassLoader) {
        this.contextClassLoader = contextClassLoader;
    }

    public DynamicType.Unloaded<?> buildUnloadedProxy(Class<?> mappedClass, Class[] interfaces) {
        return this.getByteBuddyProxyHelper().buildUnloadedProxy(mappedClass, interfaces);
    }

    private ByteBuddyProxyHelper getByteBuddyProxyHelper() {
        if (this.byteBuddyProxyHelper == null) {
            this.bytecodeProvider = new BytecodeProviderImpl(ClassFileVersion.JAVA_V8);
            this.byteBuddyProxyHelper = this.bytecodeProvider.getByteBuddyProxyHelper();
        }
        return this.byteBuddyProxyHelper;
    }

    public Class<?> uninitializedClass(String entity) {
        try {
            return Class.forName(entity, false, this.contextClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isProxiable(String managedClassOrPackageName) {
        Class<?> mappedClass;
        try {
            mappedClass = Class.forName(managedClassOrPackageName, false, this.contextClassLoader);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        if (Modifier.isFinal(mappedClass.getModifiers())) {
            return false;
        }
        try {
            mappedClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        if (this.bytecodeProvider != null) {
            this.bytecodeProvider.resetCaches();
            this.bytecodeProvider = null;
            this.byteBuddyProxyHelper = null;
        }
    }
}

