/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.persistence.remote.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.AuthenticationConfiguration;
import org.infinispan.persistence.remote.configuration.MechanismConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;

public class AuthenticationConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<AuthenticationConfiguration>,
ConfigurationBuilderInfo {
    private MechanismConfigurationBuilder mechanismConfigurationBuilder;

    public AuthenticationConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder, AuthenticationConfiguration.attributeDefinitionSet());
        this.mechanismConfigurationBuilder = new MechanismConfigurationBuilder(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return AuthenticationConfiguration.ELEMENT_DEFINITION;
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return Collections.singletonList(this.mechanismConfigurationBuilder);
    }

    public ConfigurationBuilderInfo getBuilderInfo(String name, String qualifier) {
        if (name.equals("digest") || name.equals("plain") | name.equals("external")) {
            return this.mechanismConfigurationBuilder.saslMechanism(name);
        }
        return super.getBuilderInfo(name, qualifier);
    }

    public AuthenticationConfigurationBuilder callbackHandler(CallbackHandler callbackHandler) {
        this.attributes.attribute(AuthenticationConfiguration.CALLBACK_HANDLER).set((Object)callbackHandler);
        return this;
    }

    public AuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(AuthenticationConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public AuthenticationConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public AuthenticationConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public AuthenticationConfigurationBuilder saslMechanism(String saslMechanism) {
        this.mechanismConfigurationBuilder.saslMechanism(saslMechanism);
        return this;
    }

    public AuthenticationConfigurationBuilder saslProperties(Map<String, String> saslProperties) {
        this.attributes.attribute(AuthenticationConfiguration.SASL_PROPERTIES).set(saslProperties);
        return this;
    }

    public AuthenticationConfigurationBuilder serverName(String serverName) {
        this.attributes.attribute(AuthenticationConfiguration.SERVER_NAME).set((Object)serverName);
        return this;
    }

    public AuthenticationConfigurationBuilder clientSubject(Subject clientSubject) {
        this.attributes.attribute(AuthenticationConfiguration.CLIENT_SUBJECT).set((Object)clientSubject);
        return this;
    }

    public AuthenticationConfigurationBuilder username(String username) {
        this.mechanismConfigurationBuilder.username(username);
        return this;
    }

    public AuthenticationConfigurationBuilder password(String password) {
        this.mechanismConfigurationBuilder.password(password);
        return this;
    }

    public AuthenticationConfigurationBuilder password(char[] password) {
        this.password(new String(password));
        return this;
    }

    public AuthenticationConfigurationBuilder realm(String realm) {
        this.mechanismConfigurationBuilder.realm(realm);
        return this;
    }

    public AuthenticationConfiguration create() {
        return new AuthenticationConfiguration(this.attributes.protect(), this.mechanismConfigurationBuilder.create());
    }

    public Builder<?> read(AuthenticationConfiguration template) {
        this.attributes.read(template.attributes());
        this.mechanismConfigurationBuilder.read(template.mechanismConfiguration());
        return this;
    }

    public void validate() {
    }
}

