/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.spi;

import io.quarkus.builder.item.MultiBuildItem;
import org.jboss.logging.Logger;

public final class KubernetesEnvBuildItem
extends MultiBuildItem {
    private static final Logger log = Logger.getLogger(KubernetesEnvBuildItem.class);
    private final String name;
    private final String value;
    private final String configmap;
    private final String secret;
    private final String field;
    private final EnvType type;
    private final String target;
    private final boolean oldStyle;

    public static KubernetesEnvBuildItem createFromField(String name, String targetField, String target, boolean ... oldStyle) {
        return KubernetesEnvBuildItem.create(name, null, null, null, targetField, target, KubernetesEnvBuildItem.isOldStyle(oldStyle));
    }

    public static KubernetesEnvBuildItem createFromConfigMap(String configMapName, String target, boolean ... oldStyle) {
        return KubernetesEnvBuildItem.create(configMapName, null, null, configMapName, null, target, KubernetesEnvBuildItem.isOldStyle(oldStyle));
    }

    public static KubernetesEnvBuildItem createFromSecret(String secretName, String target, boolean ... oldStyle) {
        return KubernetesEnvBuildItem.create(secretName, null, secretName, null, null, target, KubernetesEnvBuildItem.isOldStyle(oldStyle));
    }

    public static KubernetesEnvBuildItem createSimpleVar(String name, String value, String target, boolean ... oldStyle) {
        return KubernetesEnvBuildItem.create(name, value, null, null, null, target, KubernetesEnvBuildItem.isOldStyle(oldStyle));
    }

    public static KubernetesEnvBuildItem createFromConfigMapKey(String varName, String key, String configmap, String target, boolean ... oldStyle) {
        return KubernetesEnvBuildItem.create(varName, key, null, configmap, null, target, KubernetesEnvBuildItem.isOldStyle(oldStyle));
    }

    public static KubernetesEnvBuildItem createFromSecretKey(String varName, String key, String secret, String target, boolean ... oldStyle) {
        return KubernetesEnvBuildItem.create(varName, key, secret, null, null, target, KubernetesEnvBuildItem.isOldStyle(oldStyle));
    }

    public static KubernetesEnvBuildItem createFromResourceKey(String varName, String key, String secret, String configmap, String target, boolean ... oldStyle) {
        return KubernetesEnvBuildItem.create(varName, key, secret, configmap, null, target, KubernetesEnvBuildItem.isOldStyle(oldStyle));
    }

    public static KubernetesEnvBuildItem create(String name, String value, String secret, String configmap, String field, String target, boolean ... oldStyle) throws IllegalArgumentException {
        EnvType type;
        boolean fieldPresent;
        boolean secretPresent = secret != null;
        boolean configmapPresent = configmap != null;
        boolean valuePresent = value != null;
        boolean bl = fieldPresent = field != null;
        if (valuePresent) {
            if (secretPresent && configmapPresent) {
                throw new IllegalArgumentException(String.format("'%s' env var can't simultaneously take its value from '%s' configmap & '%s' secret", name, configmap, secret));
            }
            if (fieldPresent) {
                throw new IllegalArgumentException(String.format("'%s' env var can't simultaneously have a '%s' value & take is value from the '%s' field", name, value, field));
            }
        }
        if (secretPresent && configmapPresent) {
            log.warn((Object)String.format("The '%s' name was used to try to import both from '%s' secret & '%s' configmap. Only values from '%s' secret will be imported.\nIf you want to import from both, use a different property name for either.", name, secret, configmap, secret));
        }
        if (secretPresent) {
            if (valuePresent) {
                type = EnvType.keyFromSecret;
            } else {
                name = secret;
                type = EnvType.secret;
            }
        } else if (configmapPresent) {
            if (valuePresent) {
                type = EnvType.keyFromConfigmap;
            } else {
                name = configmap;
                type = EnvType.configmap;
            }
        } else {
            type = field != null ? EnvType.field : EnvType.var;
        }
        return new KubernetesEnvBuildItem(name, value, configmap, secret, field, type, target, KubernetesEnvBuildItem.isOldStyle(oldStyle));
    }

    private static boolean isOldStyle(boolean[] oldStyle) {
        return oldStyle.length >= 1 && oldStyle[0];
    }

    KubernetesEnvBuildItem(String name, String value, String configmap, String secret, String field, EnvType type, String target, boolean oldStyle) {
        this.name = name;
        this.value = value;
        this.configmap = configmap;
        this.secret = secret;
        this.field = field;
        this.type = type;
        this.target = target;
        this.oldStyle = oldStyle;
    }

    public String getConfigMap() {
        return this.configmap;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getField() {
        return this.field;
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public EnvType getType() {
        return this.type;
    }

    public String getTarget() {
        return this.target;
    }

    public KubernetesEnvBuildItem newWithTarget(String newTarget) {
        return new KubernetesEnvBuildItem(this.name, this.value, this.configmap, this.secret, this.field, this.type, newTarget, this.oldStyle);
    }

    public String toString() {
        switch (this.type) {
            case var: {
                return String.format("'%s' env var with value '%s'", this.name, this.value);
            }
            case field: {
                return String.format("'%s' env var with value from field '%s'", this.name, this.field);
            }
            case secret: {
                return "all values from '" + this.secret + "' secret";
            }
            case configmap: {
                return "all values from '" + this.configmap + "' configmap";
            }
            case keyFromConfigmap: {
                return String.format("'%s' env var with value from '%s' key of '%s' configmap", this.name, this.value, this.configmap);
            }
            case keyFromSecret: {
                return String.format("'%s' env var with value from '%s' key of '%s' secret", this.name, this.value, this.secret);
            }
        }
        return "unknown type '" + (Object)((Object)this.type) + "'";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KubernetesEnvBuildItem that = (KubernetesEnvBuildItem)((Object)o);
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.configmap != null ? !this.configmap.equals(that.configmap) : that.configmap != null) {
            return false;
        }
        if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) {
            return false;
        }
        if (this.field != null ? !this.field.equals(that.field) : that.field != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.configmap != null ? this.configmap.hashCode() : 0);
        result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public static enum EnvType {
        var(false),
        field(false),
        secret(true),
        configmap(true),
        keyFromConfigmap(false),
        keyFromSecret(false);

        public final boolean allowMultipleDefinitions;

        private EnvType(boolean allowMultipleDefinitions) {
            this.allowMultipleDefinitions = allowMultipleDefinitions;
        }

        public boolean mightConflictWith(EnvType type) {
            if (this == type) {
                return true;
            }
            switch (this) {
                case field: {
                    return type == var || type == keyFromConfigmap || type == keyFromSecret;
                }
                case var: {
                    return type == field || type == keyFromConfigmap || type == keyFromSecret;
                }
                case secret: {
                    return type == configmap;
                }
                case configmap: {
                    return type == secret;
                }
                case keyFromConfigmap: {
                    return type == field || type == var || type == keyFromSecret;
                }
                case keyFromSecret: {
                    return type == field || type == var || type == keyFromConfigmap;
                }
            }
            return false;
        }
    }
}

