/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.util;

import com.ibm.asyncutil.util.AsyncCloseable;
import com.ibm.asyncutil.util.CompletedStage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;

public class StageSupport {
    private StageSupport() {
    }

    public static CompletionStage<Void> voidStage() {
        return CompletedStage.VOID;
    }

    public static <T> CompletionStage<Void> voided(CompletionStage<T> stage) {
        return stage.thenApply(ig -> null);
    }

    public static <T> CompletionStage<T> completedStage(T t) {
        return CompletedStage.of(t);
    }

    public static <T> CompletionStage<T> exceptionalStage(Throwable ex) {
        return CompletedStage.exception(ex);
    }

    public static <T, R extends AutoCloseable> CompletionStage<T> tryWith(CompletionStage<R> resource, Function<? super R, ? extends T> fn) {
        return resource.thenApply(r -> {
            try (AutoCloseable rtemp = r;){
                Object r2 = fn.apply((Object)r);
                return r2;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Throwable ex) {
                throw new CompletionException(ex);
            }
        });
    }

    public static <T, R extends AutoCloseable> CompletionStage<T> tryComposeWith(CompletionStage<R> resource, Function<? super R, ? extends CompletionStage<T>> fn) {
        return resource.thenCompose(r -> {
            CompletableFuture ret = new CompletableFuture();
            try {
                ((CompletionStage)fn.apply((Object)r)).whenComplete((t, actionEx) -> {
                    try {
                        r.close();
                        if (actionEx != null) {
                            ret.completeExceptionally((Throwable)actionEx);
                        } else {
                            ret.complete(t);
                        }
                    }
                    catch (Exception closeEx) {
                        if (actionEx != null) {
                            actionEx.addSuppressed(closeEx);
                            ret.completeExceptionally((Throwable)actionEx);
                        }
                        ret.completeExceptionally(closeEx);
                    }
                });
            }
            catch (Throwable actionException) {
                try {
                    r.close();
                }
                catch (Exception closeException) {
                    actionException.addSuppressed(closeException);
                }
                ret.completeExceptionally(actionException);
            }
            return ret;
        });
    }

    public static <T, R extends AsyncCloseable> CompletionStage<T> tryWith(R resource, Function<? super R, ? extends T> fn) {
        try {
            Object t = fn.apply(resource);
            try {
                return resource.close().thenApply(ig -> t);
            }
            catch (Throwable ex) {
                return StageSupport.exceptionalStage(ex);
            }
        }
        catch (Throwable ex) {
            try {
                return resource.close().handle((ig, closeEx) -> {
                    if (closeEx != null) {
                        ex.addSuppressed((Throwable)closeEx);
                    }
                    throw ex;
                });
            }
            catch (Throwable closeEx2) {
                ex.addSuppressed(closeEx2);
                return StageSupport.exceptionalStage(ex);
            }
        }
    }

    public static <T, R extends AsyncCloseable> CompletionStage<T> tryComposeWith(R resource, Function<? super R, ? extends CompletionStage<T>> fn) {
        try {
            CompletionStage<Object> stage = fn.apply(resource);
            CompletableFuture ret = new CompletableFuture();
            stage.whenComplete((t, ex) -> {
                try {
                    resource.close().whenComplete((ig, closeEx) -> {
                        if (ex != null) {
                            if (closeEx != null) {
                                ex.addSuppressed((Throwable)closeEx);
                            }
                            ret.completeExceptionally((Throwable)ex);
                        } else if (closeEx != null) {
                            ret.completeExceptionally((Throwable)closeEx);
                        } else {
                            ret.complete(t);
                        }
                    });
                }
                catch (Throwable closeEx2) {
                    if (ex != null) {
                        ex.addSuppressed(closeEx2);
                        ret.completeExceptionally((Throwable)ex);
                    }
                    ret.completeExceptionally(closeEx2);
                }
            });
            return ret;
        }
        catch (Throwable ex2) {
            CompletableFuture ret = new CompletableFuture();
            try {
                resource.close().whenComplete((ig, closeEx) -> {
                    if (closeEx != null) {
                        ex2.addSuppressed((Throwable)closeEx);
                    }
                    ret.completeExceptionally(ex2);
                });
            }
            catch (Throwable closeEx2) {
                ex2.addSuppressed(closeEx2);
                ret.completeExceptionally(ex2);
            }
            return ret;
        }
    }

    public static <T, U> CompletionStage<U> thenComposeOrRecover(CompletionStage<T> stage, BiFunction<? super T, Throwable, ? extends CompletionStage<U>> fn) {
        CompletableFuture ret = new CompletableFuture();
        stage.whenComplete((t, throwable) -> {
            try {
                ((CompletionStage)fn.apply((Object)t, (Throwable)throwable)).whenComplete((u, ex2) -> {
                    if (ex2 != null) {
                        ret.completeExceptionally((Throwable)ex2);
                    }
                    ret.complete(u);
                });
            }
            catch (Throwable e) {
                ret.completeExceptionally(e);
            }
        });
        return ret;
    }
}

