/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.devmode;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.jboss.logging.Logger;

public class DependenciesFilter {
    private static final Logger log = Logger.getLogger(DependenciesFilter.class);

    public static List<LocalProject> filterNotReloadableDependencies(LocalProject localProject, MavenArtifactResolver mvnResolver) throws BootstrapMavenException {
        AppArtifact appArtifact = localProject.getAppArtifact("jar");
        final ArrayList<org.apache.maven.artifact.Artifact> projectDeps = new ArrayList<org.apache.maven.artifact.Artifact>();
        mvnResolver.resolveDependencies((Artifact)new DefaultArtifact(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getClassifier(), appArtifact.getType(), appArtifact.getVersion()), Collections.emptyList()).getRoot().accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                Dependency dep = node.getDependency();
                if (dep != null && dep.getArtifact().getFile().isDirectory()) {
                    Artifact a = dep.getArtifact();
                    org.apache.maven.artifact.DefaultArtifact mvnArtifact = new org.apache.maven.artifact.DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), dep.getScope(), a.getExtension(), a.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler("jar"));
                    mvnArtifact.setFile(a.getFile());
                    projectDeps.add(mvnArtifact);
                }
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                return true;
            }
        }));
        return DependenciesFilter.filterNotReloadableDependencies(localProject, projectDeps, mvnResolver.getSystem(), mvnResolver.getSession(), mvnResolver.getRepositories());
    }

    public static List<LocalProject> filterNotReloadableDependencies(LocalProject localProject, Iterable<org.apache.maven.artifact.Artifact> projectDeps, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> repos) {
        LocalWorkspace workspace = localProject.getWorkspace();
        if (workspace == null) {
            return Collections.singletonList(localProject);
        }
        ArrayList<LocalProject> ret = new ArrayList<LocalProject>();
        final HashSet extensionsAndDeps = new HashSet();
        ret.add(localProject);
        for (org.apache.maven.artifact.Artifact a : projectDeps) {
            AppArtifactKey depKey = new AppArtifactKey(a.getGroupId(), a.getArtifactId());
            LocalProject project = workspace.getProject(depKey);
            if (project == null) continue;
            if (!project.getVersion().equals(a.getVersion())) {
                log.warn((Object)(depKey + " is excluded from live coding since the application depends on version " + a.getVersion() + " while the version present in the workspace is " + project.getVersion()));
                continue;
            }
            if (project.getClassesDir() != null && (Files.exists(project.getClassesDir().resolve("META-INF/quarkus-extension.properties"), new LinkOption[0]) || Files.exists(project.getClassesDir().resolve("META-INF/quarkus-build-steps.list"), new LinkOption[0]))) {
                DependenciesFilter.extensionDepWarning(depKey);
                try {
                    DependencyNode depRoot = repoSystem.collectDependencies(repoSession, new CollectRequest().setRoot(new Dependency((Artifact)new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getArtifactHandler().getExtension(), a.getVersion()), "runtime")).setRepositories(repos)).getRoot();
                    depRoot.accept(new DependencyVisitor(){

                        public boolean visitEnter(DependencyNode node) {
                            Artifact artifact = node.getArtifact();
                            if ("jar".equals(artifact.getExtension())) {
                                extensionsAndDeps.add(new AppArtifactKey(artifact.getGroupId(), artifact.getArtifactId()));
                            }
                            return true;
                        }

                        public boolean visitLeave(DependencyNode node) {
                            return true;
                        }
                    });
                    continue;
                }
                catch (DependencyCollectionException e) {
                    throw new RuntimeException("Failed to collect dependencies for " + a, e);
                }
            }
            ret.add(project);
        }
        if (extensionsAndDeps.isEmpty()) {
            return ret;
        }
        Iterator iterator = ret.iterator();
        while (iterator.hasNext()) {
            LocalProject localDep = (LocalProject)iterator.next();
            if (!extensionsAndDeps.contains(localDep.getKey())) continue;
            DependenciesFilter.extensionDepWarning(localDep.getKey());
            iterator.remove();
        }
        return ret;
    }

    private static void extensionDepWarning(AppArtifactKey key) {
        log.warn((Object)("Local Quarkus extension dependency " + key + " will not be hot-reloadable"));
    }
}

