/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.AnnotationCreator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public interface AnnotatedElement {
    default public AnnotationCreator addAnnotation(String annotationType) {
        return this.addAnnotation(annotationType, RetentionPolicy.RUNTIME);
    }

    public AnnotationCreator addAnnotation(String var1, RetentionPolicy var2);

    default public AnnotationCreator addAnnotation(Class<?> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        return this.addAnnotation(annotationType.getName(), retention == null ? RetentionPolicy.SOURCE : retention.value());
    }

    default public void addAnnotation(AnnotationInstance annotation) {
        AnnotationCreator ac = this.addAnnotation(annotation.name().toString());
        for (AnnotationValue member : annotation.values()) {
            if (member.kind() == AnnotationValue.Kind.NESTED) {
                throw new RuntimeException("Not Yet Implemented: Cannot generate annotation " + annotation);
            }
            if (member.kind() == AnnotationValue.Kind.BOOLEAN) {
                ac.addValue(member.name(), member.asBoolean());
                continue;
            }
            if (member.kind() == AnnotationValue.Kind.BYTE) {
                ac.addValue(member.name(), member.asByte());
                continue;
            }
            if (member.kind() == AnnotationValue.Kind.SHORT) {
                ac.addValue(member.name(), member.asShort());
                continue;
            }
            if (member.kind() == AnnotationValue.Kind.INTEGER) {
                ac.addValue(member.name(), member.asInt());
                continue;
            }
            if (member.kind() == AnnotationValue.Kind.LONG) {
                ac.addValue(member.name(), member.asLong());
                continue;
            }
            if (member.kind() == AnnotationValue.Kind.FLOAT) {
                ac.addValue(member.name(), Float.valueOf(member.asFloat()));
                continue;
            }
            if (member.kind() == AnnotationValue.Kind.DOUBLE) {
                ac.addValue(member.name(), member.asDouble());
                continue;
            }
            if (member.kind() == AnnotationValue.Kind.STRING) {
                ac.addValue(member.name(), member.asString());
                continue;
            }
            if (member.kind() == AnnotationValue.Kind.ARRAY) {
                ac.addValue(member.name(), member.value());
                continue;
            }
            if (member.kind() != AnnotationValue.Kind.ENUM) continue;
            Class<?> enumType = null;
            try {
                enumType = Class.forName(member.asEnumType().toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (enumType != null) {
                Object enumVal = Enum.valueOf(enumType, member.asEnum());
                ac.addValue(member.name(), enumVal);
                continue;
            }
            throw new IllegalArgumentException("typeName must be an enum for: " + member.name());
        }
    }
}

