/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.ws.rs.ApplicationPath;
import org.keycloak.QuarkusKeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.quarkus.QuarkusPlatform;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.QuarkusWelcomeResource;
import org.keycloak.services.resources.WelcomeResource;

@ApplicationPath(value="/")
public class QuarkusKeycloakApplication
extends KeycloakApplication {
    @Inject
    Instance<EntityManagerFactory> entityManagerFactory;

    private static boolean filterSingletons(Object o) {
        return !WelcomeResource.class.isInstance(o);
    }

    protected void startup() {
        try {
            this.forceEntityManagerInitialization();
            this.initializeKeycloakSessionFactory();
            QuarkusKeycloakApplication.setupScheduledTasks((KeycloakSessionFactory)sessionFactory);
        }
        catch (Throwable cause) {
            QuarkusPlatform.exitOnError(cause);
        }
    }

    public Set<Object> getSingletons() {
        Set<Object> singletons = super.getSingletons().stream().filter(QuarkusKeycloakApplication::filterSingletons).collect(Collectors.toSet());
        singletons.add(new QuarkusWelcomeResource());
        return singletons;
    }

    private void initializeKeycloakSessionFactory() {
        QuarkusKeycloakSessionFactory instance = QuarkusKeycloakSessionFactory.getInstance();
        sessionFactory = instance;
        instance.init();
        sessionFactory.publish((ProviderEvent)new PostMigrationEvent());
    }

    private void forceEntityManagerInitialization() {
        ((EntityManagerFactory)this.entityManagerFactory.get()).createEntityManager().close();
    }
}

