/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cli;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.cli.MainCommand;
import org.keycloak.common.Profile;
import org.keycloak.configuration.PropertyMapper;
import org.keycloak.configuration.PropertyMappers;
import org.keycloak.platform.Platform;
import org.keycloak.provider.quarkus.InitializationException;
import org.keycloak.provider.quarkus.QuarkusPlatform;
import org.keycloak.util.Environment;
import picocli.CommandLine;

final class Picocli {
    private static final Logger logger = Logger.getLogger(Picocli.class);

    Picocli() {
    }

    static CommandLine createCommandLine() {
        CommandLine.Model.CommandSpec spec = CommandLine.Model.CommandSpec.forAnnotatedObject((Object)new MainCommand()).name(Environment.getCommand());
        Picocli.addOption(spec, "start", PropertyMappers.getRuntimeMappers());
        Picocli.addOption(spec, "start-dev", PropertyMappers.getRuntimeMappers());
        Picocli.addOption(spec, "config", PropertyMappers.getRuntimeMappers());
        Picocli.addOption(spec, "config", PropertyMappers.getBuiltTimeMappers());
        Picocli.addOption(((CommandLine)spec.subcommands().get("config")).getCommandSpec(), "--features", "Enables a group of features. Possible values are: " + String.join((CharSequence)",", (CharSequence[])Arrays.asList(Profile.Type.values()).stream().map(type -> type.name().toLowerCase()).toArray(String[]::new)));
        for (Profile.Feature feature : Profile.Feature.values()) {
            Picocli.addOption(((CommandLine)spec.subcommands().get("config")).getCommandSpec(), "--features-" + feature.name().toLowerCase(), "Enables the " + feature.name() + " feature. Set enabled to enable the feature or disabled otherwise.");
        }
        CommandLine cmd = new CommandLine((Object)spec);
        cmd.setExecutionExceptionHandler(new CommandLine.IExecutionExceptionHandler(){

            public int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult parseResult) {
                commandLine.getErr().println(ex.getMessage());
                commandLine.usage(commandLine.getErr());
                return commandLine.getCommandSpec().exitCodeOnExecutionException();
            }
        });
        return cmd;
    }

    static String parseConfigArgs(List<String> argsList) {
        StringBuilder options = new StringBuilder();
        Iterator<String> iterator = argsList.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (key.startsWith("--spi")) {
                iterator.remove();
            }
            if (!key.startsWith("--")) continue;
            if (options.length() > 0) {
                options.append(",");
            }
            options.append(key);
        }
        return options.toString();
    }

    private static void addOption(CommandLine.Model.CommandSpec spec, String command, List<PropertyMapper> mappers) {
        CommandLine.Model.CommandSpec commandSpec = ((CommandLine)spec.subcommands().get(command)).getCommandSpec();
        for (PropertyMapper mapper : mappers) {
            String name = "--" + PropertyMappers.toCLIFormat(mapper.getFrom()).substring(3);
            String description = mapper.getDescription();
            if (description == null || commandSpec.optionsMap().containsKey(name)) continue;
            Picocli.addOption(commandSpec, name, description);
        }
    }

    private static void addOption(CommandLine.Model.CommandSpec commandSpec, String name, String description) {
        commandSpec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)name, (String[])new String[0]).description(new String[]{description})).paramLabel("<value>")).type(String.class)).build());
    }

    static List<String> getCliArgs(CommandLine cmd) {
        CommandLine.ParseResult parseResult = cmd.getParseResult();
        if (parseResult == null) {
            return Collections.emptyList();
        }
        return parseResult.expandedArgs();
    }

    static void error(List<String> cliArgs, PrintWriter errorWriter, String message, Throwable throwable) {
        Picocli.logError(errorWriter, "ERROR: " + message);
        if (throwable != null) {
            boolean verbose = cliArgs.stream().anyMatch(arg -> "--verbose".equals(arg));
            if (throwable instanceof InitializationException) {
                InitializationException initializationException = (InitializationException)throwable;
                if (initializationException.getSuppressed() == null || initializationException.getSuppressed().length == 0) {
                    Picocli.dumpException(errorWriter, initializationException, verbose);
                } else if (initializationException.getSuppressed().length == 1) {
                    Picocli.dumpException(errorWriter, initializationException.getSuppressed()[0], verbose);
                } else {
                    Picocli.logError(errorWriter, "ERROR: Multiple configuration errors during startup");
                    int counter = 0;
                    for (Throwable inner : initializationException.getSuppressed()) {
                        Picocli.logError(errorWriter, "ERROR " + ++counter);
                        Picocli.dumpException(errorWriter, inner, verbose);
                    }
                }
            } else {
                Picocli.dumpException(errorWriter, throwable, verbose);
            }
            if (!verbose) {
                Picocli.logError(errorWriter, "For more details run the same command passing the '--verbose' option. Also you can use '--help' to see the details about the usage of the particular command.");
            }
        }
        System.exit(1);
    }

    static void error(CommandLine cmd, String message, Throwable throwable) {
        Picocli.error(Picocli.getCliArgs(cmd), cmd.getErr(), message, throwable);
    }

    static void error(CommandLine cmd, String message) {
        Picocli.error(Picocli.getCliArgs(cmd), cmd.getErr(), message, null);
    }

    static void println(CommandLine cmd, String message) {
        cmd.getOut().println(message);
    }

    private static void dumpException(PrintWriter errorWriter, Throwable cause, boolean verbose) {
        if (verbose) {
            Picocli.logError(errorWriter, "ERROR: Details:", cause);
        } else {
            do {
                if (cause.getMessage() == null) continue;
                Picocli.logError(errorWriter, String.format("ERROR: %s", cause.getMessage()));
            } while ((cause = cause.getCause()) != null);
        }
    }

    private static void logError(PrintWriter errorWriter, String errorMessage) {
        Picocli.logError(errorWriter, errorMessage, null);
    }

    private static void logError(PrintWriter errorWriter, String errorMessage, Throwable cause) {
        QuarkusPlatform platform = (QuarkusPlatform)Platform.getPlatform();
        if (platform.isStarted()) {
            if (cause == null) {
                logger.error((Object)errorMessage);
            } else {
                logger.error((Object)errorMessage, cause);
            }
        } else if (cause == null) {
            errorWriter.println(errorMessage);
        } else {
            errorWriter.println(errorMessage);
            cause.printStackTrace();
        }
    }
}

