/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.configuration;

import io.smallrye.config.PropertiesConfigSource;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StringPropertyReplacer;

public abstract class KeycloakPropertiesConfigSource
extends PropertiesConfigSource {
    private static final Logger log = Logger.getLogger(KeycloakPropertiesConfigSource.class);
    private static final Pattern DOT_SPLIT = Pattern.compile("\\.");
    static final String KEYCLOAK_PROPERTIES = "keycloak.properties";

    KeycloakPropertiesConfigSource(InputStream is, int ordinal) {
        super(KeycloakPropertiesConfigSource.readProperties(is), KEYCLOAK_PROPERTIES, ordinal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> readProperties(InputStream is) {
        if (is == null) {
            return Collections.emptyMap();
        }
        try (InputStream ignored = is;){
            Properties properties = new Properties();
            properties.load(is);
            Map<String, String> map = KeycloakPropertiesConfigSource.transform(properties);
            return map;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private static Map<String, String> transform(Map<String, String> properties) {
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        properties.keySet().forEach(k -> result.put(KeycloakPropertiesConfigSource.transformKey(k), StringPropertyReplacer.replaceProperties((String)((String)properties.get(k)))));
        return result;
    }

    private static String transformKey(String key) {
        String[] keyParts = DOT_SPLIT.split(key);
        String extension = keyParts[0];
        String profile = "";
        String transformed = key;
        if (extension.startsWith("%")) {
            profile = String.format("%s.", keyParts[0]);
            extension = keyParts[1];
            transformed = key.substring(key.indexOf(46) + 1);
        }
        if (extension.equalsIgnoreCase("quarkus")) {
            return key;
        }
        String namespace = "kc";
        return profile + namespace + "." + transformed;
    }

    public static final class InFileSystem
    extends KeycloakPropertiesConfigSource {
        public InFileSystem(Path path) {
            super(InFileSystem.openStream(path), 255);
        }

        private static InputStream openStream(Path path) {
            if (path == null) {
                throw new IllegalArgumentException("Configuration file path can not be null");
            }
            try {
                log.debugf("Loading the server configuration from %s", (Object)path);
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                throw new IllegalArgumentException("Configuration file not found at [" + path + "]");
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected error reading configuration file at [" + path + "]", e);
            }
        }
    }

    public static final class InJar
    extends KeycloakPropertiesConfigSource {
        public InJar() {
            super(InJar.openStream(), 245);
        }

        private static InputStream openStream() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = KeycloakPropertiesConfigSource.class.getClassLoader();
            }
            String fileName = "META-INF/keycloak.properties";
            InputStream is = cl == null ? ClassLoader.getSystemResourceAsStream(fileName) : cl.getResourceAsStream(fileName);
            if (is != null) {
                log.debug((Object)"Loading the server configuration from the classpath");
            }
            return is;
        }
    }
}

