/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.configuration;

import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.keycloak.configuration.PropertyMappers;
import org.keycloak.util.Environment;

public class PersistedConfigSource
extends PropertiesConfigSource {
    public static final String NAME = "PersistedConfigSource";
    static final String KEYCLOAK_PROPERTIES = "persisted.properties";

    public PersistedConfigSource(Path file) {
        super(PersistedConfigSource.readProperties(file), "", 300);
    }

    public String getName() {
        return NAME;
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public String getValue(String propertyName) {
        String value = super.getValue(propertyName);
        if (value != null) {
            return value;
        }
        if (propertyName.startsWith("kc.")) {
            return super.getValue(PropertyMappers.toCLIFormat(propertyName));
        }
        return null;
    }

    private static Map<String, String> readProperties(Path path) {
        File file;
        if (!Environment.isRebuild().booleanValue() && (file = path.toFile()).exists()) {
            try {
                return ConfigSourceUtil.urlToMap((URL)file.toURL());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load persisted properties from [" + file.getAbsolutePath() + ".", e);
            }
        }
        return Collections.emptyMap();
    }
}

