/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Case;
import io.vertx.codegen.doc.Text;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;

public class ParamInfo {
    final int index;
    final String name;
    final Text description;
    final TypeInfo type;
    final TypeInfo unresolvedType;

    public ParamInfo(int index, String name, Text description, TypeInfo type) {
        this(index, name, description, type, null);
    }

    public ParamInfo(int index, String name, Text description, TypeInfo type, TypeInfo unresolvedType) {
        this.index = index;
        this.name = name;
        this.description = description;
        this.type = type;
        this.unresolvedType = unresolvedType;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getName(Case _case) {
        return _case.format(Case.CAMEL.parse(this.name));
    }

    public Text getDescription() {
        return this.description;
    }

    public boolean isNullable() {
        return this.type.getKind() == ClassKind.OBJECT || this.type.isNullable();
    }

    public Boolean isNullableCallback() {
        switch (this.type.getKind()) {
            case HANDLER: {
                TypeInfo handler = ((ParameterizedTypeInfo)this.type).getArg(0);
                switch (handler.getKind()) {
                    case ASYNC_RESULT: {
                        TypeInfo asyncResult = ((ParameterizedTypeInfo)handler).getArg(0);
                        return asyncResult.isNullable();
                    }
                }
                return handler.isNullable();
            }
        }
        return null;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public TypeInfo getUnresolvedType() {
        return this.unresolvedType;
    }

    public boolean isDataObject() {
        return this.type instanceof ClassTypeInfo && this.type.getKind() == ClassKind.DATA_OBJECT;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ParamInfo)) {
            return false;
        }
        ParamInfo pother = (ParamInfo)other;
        return this.name.equals(pother.name) && this.type.equals(pother.type);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return this.type + " " + this.name;
    }
}

