/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.protostream.annotations.impl.HasProtoSchema;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.types.XClass;

public abstract class ProtoTypeMetadata
implements HasProtoSchema {
    protected final String name;
    protected final XClass javaClass;
    protected ProtoMessageTypeMetadata outerType;

    protected ProtoTypeMetadata(String name, XClass javaClass) {
        this.name = name;
        this.javaClass = javaClass;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        StringBuilder sb = new StringBuilder();
        ProtoMessageTypeMetadata t = this.outerType;
        while (t != null) {
            sb.append(t.getName()).append('.');
            t = t.outerType;
        }
        sb.append(this.name);
        return sb.toString();
    }

    public String getDocumentation() {
        String protoDocs = this.getProtoDocs();
        Integer protoTypeId = this.getProtoTypeId();
        if (protoTypeId != null) {
            String typeIdAnnotation = "@TypeId(" + protoTypeId + ")\n";
            protoDocs = protoDocs == null ? typeIdAnnotation : protoDocs + "\n" + typeIdAnnotation;
        }
        return protoDocs;
    }

    public String getProtoDocs() {
        return this.getAnnotatedClass().getProtoDocs();
    }

    public Integer getProtoTypeId() {
        ProtoTypeId protoTypeId = this.getAnnotatedClass().getAnnotation(ProtoTypeId.class);
        return protoTypeId != null ? Integer.valueOf(protoTypeId.value()) : null;
    }

    public XClass getJavaClass() {
        return this.javaClass;
    }

    public String getJavaClassName() {
        String canonicalName = this.javaClass.getCanonicalName();
        return canonicalName != null ? canonicalName : this.javaClass.getName();
    }

    public XClass getAnnotatedClass() {
        return this.getJavaClass();
    }

    public String getAnnotatedClassName() {
        String canonicalName = this.getAnnotatedClass().getCanonicalName();
        return canonicalName != null ? canonicalName : this.getAnnotatedClass().getName();
    }

    public boolean isAdapter() {
        return false;
    }

    public boolean isImported() {
        return false;
    }

    public String getFileName() {
        return null;
    }

    public abstract boolean isEnum();

    public abstract ProtoEnumValueMetadata getEnumMemberByName(String var1);

    public final ProtoMessageTypeMetadata getOuterType() {
        return this.outerType;
    }

    protected final void setOuterType(ProtoMessageTypeMetadata outerType) {
        this.outerType = outerType;
    }

    @Override
    public void generateProto(IndentWriter iw) {
    }

    public void scanMemberAnnotations() {
    }

    protected static void appendDocumentation(IndentWriter iw, String documentation) {
        if (documentation != null) {
            iw.append("/**\n");
            for (String s : documentation.split("\\r\\n|\\n|\\r")) {
                iw.append(" * ").append(s).append('\n');
            }
            iw.append(" */\n");
        }
    }
}

