/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.okhttp;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import javax.net.SocketFactory;
import org.testcontainers.shaded.com.github.dockerjava.okhttp.OkDockerHttpClient;
import org.testcontainers.shaded.com.github.dockerjava.okhttp.UnixDomainSocket;

class UnixSocketFactory
extends SocketFactory {
    private final String socketPath;

    UnixSocketFactory(String socketPath) {
        this.socketPath = socketPath;
    }

    @Override
    public Socket createSocket() {
        try {
            return new UnixDomainSocket(this.socketPath){

                @Override
                public void connect(SocketAddress endpoint, int timeout) throws IOException {
                    super.connect(endpoint, timeout);
                }

                @Override
                public InputStream getInputStream() {
                    return new FilterInputStream(super.getInputStream()){

                        @Override
                        public void close() throws IOException {
                            this.shutdownInput();
                        }

                        @Override
                        public int read(byte[] b, int off, int len) throws IOException {
                            if (OkDockerHttpClient.OkResponse.CLOSING.get().booleanValue()) {
                                return 0;
                            }
                            return super.read(b, off, len);
                        }
                    };
                }

                @Override
                public OutputStream getOutputStream() {
                    return new FilterOutputStream(super.getOutputStream()){

                        @Override
                        public void write(byte[] b, int off, int len) throws IOException {
                            this.out.write(b, off, len);
                        }

                        @Override
                        public void close() throws IOException {
                            this.shutdownOutput();
                        }
                    };
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Socket createSocket(String s, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) {
        throw new UnsupportedOperationException();
    }
}

