/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.ValidationException;

public final class DefaultUserProfile
implements UserProfile {
    private final Function<Attributes, UserModel> userSupplier;
    private final Attributes attributes;
    private final KeycloakSession session;
    private boolean validated;
    private UserModel user;

    public DefaultUserProfile(Attributes attributes, Function<Attributes, UserModel> userCreator, UserModel user, KeycloakSession session) {
        this.userSupplier = userCreator;
        this.attributes = attributes;
        this.user = user;
        this.session = session;
    }

    @Override
    public void validate() {
        ValidationException validationException = new ValidationException(this.session, this.user);
        for (String attributeName : this.attributes.nameSet()) {
            this.attributes.validate(attributeName, validationException);
        }
        if (validationException.hasError(new String[0])) {
            throw validationException;
        }
        this.validated = true;
    }

    @Override
    public UserModel create() throws ValidationException {
        if (this.user != null) {
            throw new RuntimeException("User already created");
        }
        if (!this.validated) {
            this.validate();
        }
        this.user = this.userSupplier.apply(this.attributes);
        return this.updateInternal(this.user, false, new BiConsumer[0]);
    }

    @Override
    public void update(boolean removeAttributes, BiConsumer<String, UserModel> ... changeListener) {
        if (!this.validated) {
            this.validate();
        }
        this.updateInternal(this.user, removeAttributes, changeListener);
    }

    private UserModel updateInternal(UserModel user, boolean removeAttributes, BiConsumer<String, UserModel> ... changeListener) {
        if (user == null) {
            throw new RuntimeException("No user model provided for persisting changes");
        }
        try {
            for (Map.Entry<String, List<String>> attribute : this.attributes.attributeSet()) {
                String name = attribute.getKey();
                if (this.attributes.isReadOnly(name)) continue;
                List currentValue = user.getAttributeStream(name).filter(Objects::nonNull).collect(Collectors.toList());
                List updatedValue = attribute.getValue().stream().filter(Objects::nonNull).collect(Collectors.toList());
                if (currentValue.size() == updatedValue.size() && currentValue.containsAll(updatedValue)) continue;
                user.setAttribute(name, updatedValue);
                for (BiConsumer<String, UserModel> listener : changeListener) {
                    listener.accept(name, user);
                }
            }
            if (removeAttributes) {
                HashSet attrsToRemove = new HashSet(user.getAttributes().keySet());
                attrsToRemove.removeAll(this.attributes.nameSet());
                for (String attr : attrsToRemove) {
                    if (this.attributes.isReadOnly(attr)) continue;
                    user.removeAttribute(attr);
                }
            }
        }
        catch (ModelException me) {
            throw me;
        }
        catch (Exception cause) {
            throw new RuntimeException("Unexpected error when persisting user profile", cause);
        }
        return user;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }
}

