/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;
import org.keycloak.models.jpa.converter.MapStringConverter;

@Entity
@IdClass(value=RealmLocalizationTextEntityKey.class)
@Table(name="REALM_LOCALIZATIONS")
public class RealmLocalizationTextsEntity {
    private static final MapStringConverter MAP_STRING_CONVERTER = new MapStringConverter();
    @Id
    @Column(name="REALM_ID")
    private String realmId;
    @Id
    @Column(name="LOCALE")
    private String locale;
    @Column(name="TEXTS")
    private String texts;

    public Map<String, String> getTexts() {
        if (this.texts == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(MAP_STRING_CONVERTER.convertToEntityAttribute(this.texts));
    }

    public void setTexts(Map<String, String> texts) {
        this.texts = texts == null ? null : MAP_STRING_CONVERTER.convertToDatabaseColumn(texts);
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String toString() {
        return "LocalizationTextEntity{, text='" + this.texts + '\'' + ", locale='" + this.locale + '\'' + ", realmId='" + this.realmId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealmLocalizationTextsEntity that = (RealmLocalizationTextsEntity)o;
        return Objects.equals(this.realmId, that.realmId) && Objects.equals(this.locale, that.locale) && Objects.equals(this.texts, that.texts);
    }

    public int hashCode() {
        return Objects.hash(this.realmId, this.locale, this.texts);
    }

    public static class RealmLocalizationTextEntityKey
    implements Serializable {
        private String realmId;
        private String locale;

        public String getRealmId() {
            return this.realmId;
        }

        public void setRealmId(String realmId) {
            this.realmId = realmId;
        }

        public String getLocale() {
            return this.locale;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RealmLocalizationTextEntityKey that = (RealmLocalizationTextEntityKey)o;
            return Objects.equals(this.realmId, that.realmId) && Objects.equals(this.locale, that.locale);
        }

        public int hashCode() {
            return Objects.hash(this.realmId, this.locale);
        }
    }
}

