/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;

public class VerifyProfileBean {
    private final UserModel user;
    private final MultivaluedMap<String, String> formData;
    private final List<Attribute> attributes;
    private final UserProfile profile;

    public VerifyProfileBean(UserModel user, MultivaluedMap<String, String> formData, KeycloakSession session) {
        this.user = user;
        this.formData = formData;
        UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        this.profile = provider.create(UserProfileContext.UPDATE_PROFILE, user);
        this.attributes = this.toAttributes(this.profile.getAttributes().getReadable());
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<Attribute> getAllAttributes() {
        return this.toAttributes(this.profile.getAttributes().toMap());
    }

    private List<Attribute> toAttributes(Map<String, List<String>> readable) {
        return readable.keySet().stream().map(name -> this.profile.getAttributes().getMetadata(name)).map(x$0 -> new Attribute((AttributeMetadata)x$0)).sorted().collect(Collectors.toList());
    }

    public class Attribute
    implements Comparable<Attribute> {
        private final AttributeMetadata metadata;

        public Attribute(AttributeMetadata metadata) {
            this.metadata = metadata;
        }

        public String getName() {
            return this.metadata.getName();
        }

        public String getValue() {
            return (String)((List)VerifyProfileBean.this.formData.getOrDefault((Object)this.getName(), Collections.singletonList(VerifyProfileBean.this.user.getFirstAttribute(this.getName())))).get(0);
        }

        public boolean isRequired() {
            return VerifyProfileBean.this.profile.getAttributes().isRequired(this.getName());
        }

        public boolean isReadOnly() {
            return VerifyProfileBean.this.profile.getAttributes().isReadOnly(this.getName());
        }

        public Map<String, Object> getAnnotations() {
            Map annotations = this.metadata.getAnnotations();
            if (annotations == null) {
                return Collections.emptyMap();
            }
            return annotations;
        }

        @Override
        public int compareTo(Attribute o) {
            return this.getName().compareTo(o.getName());
        }
    }
}

