/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.context.AdminClientUpdateContext;
import org.keycloak.services.clientpolicy.context.DynamicClientRegisterContext;
import org.keycloak.services.clientpolicy.context.DynamicClientUpdateContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureSigningAlgorithmExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(SecureSigningAlgorithmExecutor.class);
    private final KeycloakSession session;
    private Configuration configuration;
    private static final List<String> sigTargets = Arrays.asList("user.info.response.signature.alg", "request.object.signature.alg", "id.token.signed.response.alg", "token.endpoint.auth.signing.alg");
    private static final List<String> sigTargetsAdminRestApiOnly = Arrays.asList("access.token.signed.response.alg");
    private static final String DEFAULT_ALGORITHM_VALUE = "PS256";
    static final Set<String> ALLOWED_ALGORITHMS = new LinkedHashSet<String>(Arrays.asList("PS256", "PS384", "PS512", "ES256", "ES384", "ES512"));

    public SecureSigningAlgorithmExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "secure-signature-algorithm";
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = Optional.ofNullable(config).orElse(this.createDefaultConfiguration());
        if (config.getDefaultAlgorithm() == null || !SecureSigningAlgorithmExecutor.isSecureAlgorithm(config.getDefaultAlgorithm())) {
            config.setDefaultAlgorithm(DEFAULT_ALGORITHM_VALUE);
        }
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: {
                if (context instanceof AdminClientRegisterContext) {
                    this.verifyAndEnforceSecureSigningAlgorithm(((AdminClientRegisterContext)context).getProposedClientRepresentation(), true, false);
                    break;
                }
                if (context instanceof DynamicClientRegisterContext) {
                    this.verifyAndEnforceSecureSigningAlgorithm(((DynamicClientRegisterContext)context).getProposedClientRepresentation(), false, false);
                    break;
                }
                throw new ClientPolicyException("invalid_request", "not allowed input format.");
            }
            case UPDATE: {
                if (context instanceof AdminClientUpdateContext) {
                    this.verifyAndEnforceSecureSigningAlgorithm(((AdminClientUpdateContext)context).getProposedClientRepresentation(), true, true);
                    break;
                }
                if (context instanceof DynamicClientUpdateContext) {
                    this.verifyAndEnforceSecureSigningAlgorithm(((DynamicClientUpdateContext)context).getProposedClientRepresentation(), false, true);
                    break;
                }
                throw new ClientPolicyException("invalid_request", "not allowed input format.");
            }
            default: {
                return;
            }
        }
    }

    private Configuration createDefaultConfiguration() {
        Configuration conf = new Configuration();
        conf.setDefaultAlgorithm(DEFAULT_ALGORITHM_VALUE);
        return conf;
    }

    private void verifyAndEnforceSecureSigningAlgorithm(ClientRepresentation clientRep, boolean byAdminRestApi, boolean isUpdate) throws ClientPolicyException {
        for (String sigTarget : sigTargets) {
            this.verifyAndEnforceSecureSigningAlgorithm(sigTarget, clientRep);
        }
        if (byAdminRestApi) {
            for (String sigTarget : sigTargetsAdminRestApiOnly) {
                this.verifyAndEnforceSecureSigningAlgorithm(sigTarget, clientRep);
            }
        }
    }

    private void verifyAndEnforceSecureSigningAlgorithm(String sigTarget, ClientRepresentation clientRep) throws ClientPolicyException {
        Map attributes = Optional.ofNullable(clientRep.getAttributes()).orElse(new HashMap());
        String sigAlg = (String)attributes.get(sigTarget);
        if (sigAlg == null) {
            logger.tracev("Signing algorithm not specified explicitly, signature target = {0}. set default algorithm = {1}.", (Object)sigTarget, (Object)this.configuration.getDefaultAlgorithm());
            attributes.put(sigTarget, this.configuration.getDefaultAlgorithm());
            clientRep.setAttributes(attributes);
            return;
        }
        if (SecureSigningAlgorithmExecutor.isSecureAlgorithm(sigAlg)) {
            logger.tracev("Passed. signature target = {0}, signature algorithm = {1}", (Object)sigTarget, (Object)sigAlg);
            return;
        }
        logger.tracev("NOT allowed signatureAlgorithm. signature target = {0}, signature algorithm = {1}", (Object)sigTarget, (Object)sigAlg);
        throw new ClientPolicyException("invalid_request", "not allowed signature algorithm.");
    }

    private static boolean isSecureAlgorithm(String sigAlg) {
        return ALLOWED_ALGORITHMS.contains(sigAlg);
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="default-algorithm")
        protected String defaultAlgorithm;

        public String getDefaultAlgorithm() {
            return this.defaultAlgorithm;
        }

        public void setDefaultAlgorithm(String defaultAlgorithm) {
            if (SecureSigningAlgorithmExecutor.isSecureAlgorithm(defaultAlgorithm)) {
                this.defaultAlgorithm = defaultAlgorithm;
            } else {
                logger.tracev("defaultAlgorithm = {0}, fall back to {1}.", (Object)defaultAlgorithm, (Object)SecureSigningAlgorithmExecutor.DEFAULT_ALGORITHM_VALUE);
                this.defaultAlgorithm = SecureSigningAlgorithmExecutor.DEFAULT_ALGORITHM_VALUE;
            }
        }
    }
}

