/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.policy.PasswordPolicyNotMetException;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.UserProfileResource;
import org.keycloak.services.resources.admin.UserResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.UserPermissionEvaluator;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;

public class UsersResource {
    private static final Logger logger = Logger.getLogger(UsersResource.class);
    private static final String SEARCH_ID_PARAMETER = "id:";
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public UsersResource(RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent.resource(ResourceType.USER);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createUser(UserRepresentation rep) {
        try {
            this.auth.users().requireManage();
        }
        catch (ForbiddenException exception) {
            if (rep.getGroups() != null) {
                for (String groupPath : rep.getGroups()) {
                    GroupModel group = KeycloakModelUtils.findGroupByPath((RealmModel)this.realm, (String)groupPath);
                    if (group != null) {
                        this.auth.groups().requireManageMembers(group);
                        this.auth.groups().requireManageMembership(group);
                        continue;
                    }
                    return ErrorResponse.error(String.format("Group %s not found", groupPath), Response.Status.BAD_REQUEST);
                }
            }
            throw exception;
        }
        String username = rep.getUsername();
        if (this.realm.isRegistrationEmailAsUsername()) {
            username = rep.getEmail();
        }
        if (ObjectUtil.isBlank((CharSequence)username)) {
            return ErrorResponse.error("User name is missing", Response.Status.BAD_REQUEST);
        }
        if (this.session.users().getUserByUsername(this.realm, username) != null) {
            return ErrorResponse.exists("User exists with same username");
        }
        if (rep.getEmail() != null && !this.realm.isDuplicateEmailsAllowed()) {
            try {
                if (this.session.users().getUserByEmail(this.realm, rep.getEmail()) != null) {
                    return ErrorResponse.exists("User exists with same email");
                }
            }
            catch (ModelDuplicateException e) {
                return ErrorResponse.exists("User exists with same email");
            }
        }
        UserProfileProvider profileProvider = (UserProfileProvider)this.session.getProvider(UserProfileProvider.class);
        UserProfile profile = profileProvider.create(UserProfileContext.USER_API, rep.toAttributes());
        try {
            Response response = UserResource.validateUserProfile(profile, null, this.session);
            if (response != null) {
                return response;
            }
            UserModel user = profile.create();
            UserResource.updateUserFromRep(profile, user, rep, this.session, false);
            RepresentationToModel.createFederatedIdentities((UserRepresentation)rep, (KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user);
            RepresentationToModel.createGroups((UserRepresentation)rep, (RealmModel)this.realm, (UserModel)user);
            RepresentationToModel.createCredentials((UserRepresentation)rep, (KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user, (boolean)true);
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), user.getId()).representation(rep).success();
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().commit();
            }
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(user.getId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            return ErrorResponse.exists("User exists with same username or email");
        }
        catch (PasswordPolicyNotMetException e) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            return ErrorResponse.error("Password policy not met", Response.Status.BAD_REQUEST);
        }
        catch (ModelException me) {
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            logger.warn((Object)"Could not create user", (Throwable)me);
            return ErrorResponse.error("Could not create user", Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="{id}")
    public UserResource user(@PathParam(value="id") String id) {
        UserModel user = this.session.users().getUserById(this.realm, id);
        if (user == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("User not found");
            }
            throw new ForbiddenException();
        }
        UserResource resource = new UserResource(this.realm, user, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    /*
     * Enabled aggressive block sorting
     */
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<UserRepresentation> getUsers(@QueryParam(value="search") String search, @QueryParam(value="lastName") String last, @QueryParam(value="firstName") String first, @QueryParam(value="email") String email, @QueryParam(value="username") String username, @QueryParam(value="emailVerified") Boolean emailVerified, @QueryParam(value="idpAlias") String idpAlias, @QueryParam(value="idpUserId") String idpUserId, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults, @QueryParam(value="enabled") Boolean enabled, @QueryParam(value="briefRepresentation") Boolean briefRepresentation, @QueryParam(value="exact") Boolean exact) {
        UserPermissionEvaluator userPermissionEvaluator = this.auth.users();
        userPermissionEvaluator.requireQuery();
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : 100;
        Stream<UserModel> userModels = Stream.empty();
        if (search != null) {
            if (search.startsWith(SEARCH_ID_PARAMETER)) {
                UserModel userModel = this.session.users().getUserById(this.realm, search.substring(SEARCH_ID_PARAMETER.length()).trim());
                if (userModel == null) return this.toRepresentation(this.realm, userPermissionEvaluator, briefRepresentation, userModels);
                userModels = Stream.of(userModel);
                return this.toRepresentation(this.realm, userPermissionEvaluator, briefRepresentation, userModels);
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("keycloak.session.realm.users.query.search", search.trim());
            if (enabled == null) return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, false);
            attributes.put("enabled", enabled.toString());
            return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, false);
        }
        if (last == null && first == null && email == null && username == null && emailVerified == null && idpAlias == null && idpUserId == null && enabled == null) {
            if (exact == null) return this.searchForUser(new HashMap<String, String>(), this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, false);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (last != null) {
            attributes.put("lastName", last);
        }
        if (first != null) {
            attributes.put("firstName", first);
        }
        if (email != null) {
            attributes.put("email", email);
        }
        if (username != null) {
            attributes.put("username", username);
        }
        if (emailVerified != null) {
            attributes.put("emailVerified", emailVerified.toString());
        }
        if (idpAlias != null) {
            attributes.put("keycloak.session.realm.users.query.idp_alias", idpAlias);
        }
        if (idpUserId != null) {
            attributes.put("keycloak.session.realm.users.query.idp_user_id", idpUserId);
        }
        if (enabled != null) {
            attributes.put("enabled", enabled.toString());
        }
        if (exact == null) return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, true);
        attributes.put("keycloak.session.realm.users.query.exact", exact.toString());
        return this.searchForUser(attributes, this.realm, userPermissionEvaluator, briefRepresentation, firstResult, maxResults, true);
    }

    @Path(value="count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Integer getUsersCount(@QueryParam(value="search") String search, @QueryParam(value="lastName") String last, @QueryParam(value="firstName") String first, @QueryParam(value="email") String email, @QueryParam(value="emailVerified") Boolean emailVerified, @QueryParam(value="username") String username) {
        UserPermissionEvaluator userPermissionEvaluator = this.auth.users();
        userPermissionEvaluator.requireQuery();
        if (search != null) {
            if (search.startsWith(SEARCH_ID_PARAMETER)) {
                UserModel userModel = this.session.users().getUserById(this.realm, search.substring(SEARCH_ID_PARAMETER.length()).trim());
                return userModel != null && userPermissionEvaluator.canView(userModel) ? 1 : 0;
            }
            if (userPermissionEvaluator.canView()) {
                return this.session.users().getUsersCount(this.realm, search.trim());
            }
            return this.session.users().getUsersCount(this.realm, search.trim(), this.auth.groups().getGroupsWithViewPermission());
        }
        if (last != null || first != null || email != null || username != null || emailVerified != null) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (last != null) {
                parameters.put("lastName", last);
            }
            if (first != null) {
                parameters.put("firstName", first);
            }
            if (email != null) {
                parameters.put("email", email);
            }
            if (username != null) {
                parameters.put("username", username);
            }
            if (emailVerified != null) {
                parameters.put("emailVerified", emailVerified.toString());
            }
            if (userPermissionEvaluator.canView()) {
                return this.session.users().getUsersCount(this.realm, parameters);
            }
            return this.session.users().getUsersCount(this.realm, parameters, this.auth.groups().getGroupsWithViewPermission());
        }
        if (userPermissionEvaluator.canView()) {
            return this.session.users().getUsersCount(this.realm);
        }
        return this.session.users().getUsersCount(this.realm, this.auth.groups().getGroupsWithViewPermission());
    }

    @Path(value="profile")
    public UserProfileResource userProfile() {
        UserProfileResource resource = new UserProfileResource(this.realm, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    private Stream<UserRepresentation> searchForUser(Map<String, String> attributes, RealmModel realm, UserPermissionEvaluator usersEvaluator, Boolean briefRepresentation, Integer firstResult, Integer maxResults, Boolean includeServiceAccounts) {
        Set<String> groupModels;
        this.session.setAttribute("keycloak.session.realm.users.query.include_service_account", (Object)includeServiceAccounts);
        if (!this.auth.users().canView() && !(groupModels = this.auth.groups().getGroupsWithViewPermission()).isEmpty()) {
            this.session.setAttribute("keycloak.session.realm.users.query.groups", groupModels);
        }
        Stream userModels = this.session.users().searchForUserStream(realm, attributes, firstResult, maxResults);
        return this.toRepresentation(realm, usersEvaluator, briefRepresentation, userModels);
    }

    private Stream<UserRepresentation> toRepresentation(RealmModel realm, UserPermissionEvaluator usersEvaluator, Boolean briefRepresentation, Stream<UserModel> userModels) {
        boolean briefRepresentationB = briefRepresentation != null && briefRepresentation != false;
        boolean canViewGlobal = usersEvaluator.canView();
        usersEvaluator.grantIfNoPermission(this.session.getAttribute("keycloak.session.realm.users.query.groups") != null);
        return userModels.filter(user -> canViewGlobal || usersEvaluator.canView((UserModel)user)).map(user -> {
            UserRepresentation userRep = briefRepresentationB ? ModelToRepresentation.toBriefRepresentation((UserModel)user) : ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)realm, (UserModel)user);
            userRep.setAccess(usersEvaluator.getAccess((UserModel)user));
            return userRep;
        });
    }
}

