/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.HealthState;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ExecInContainerPattern;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.utility.LogUtils;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.ThrowingFunction;

public interface ContainerState {
    public static final String STATE_HEALTHY = "healthy";

    default public String getContainerIpAddress() {
        return this.getHost();
    }

    default public String getHost() {
        return DockerClientFactory.instance().dockerHostIpAddress();
    }

    default public boolean isRunning() {
        if (this.getContainerId() == null) {
            return false;
        }
        try {
            Boolean running = this.getCurrentContainerInfo().getState().getRunning();
            return Boolean.TRUE.equals(running);
        }
        catch (DockerException e) {
            return false;
        }
    }

    default public boolean isCreated() {
        if (this.getContainerId() == null) {
            return false;
        }
        try {
            String status = this.getCurrentContainerInfo().getState().getStatus();
            return "created".equalsIgnoreCase(status) || this.isRunning();
        }
        catch (DockerException e) {
            return false;
        }
    }

    default public boolean isHealthy() {
        if (this.getContainerId() == null) {
            return false;
        }
        try {
            InspectContainerResponse inspectContainerResponse = this.getCurrentContainerInfo();
            HealthState health = inspectContainerResponse.getState().getHealth();
            if (health == null) {
                throw new RuntimeException("This container's image does not have a healthcheck declared, so health cannot be determined. Either amend the image or use another approach to determine whether containers are healthy.");
            }
            return STATE_HEALTHY.equals(health.getStatus());
        }
        catch (DockerException e) {
            return false;
        }
    }

    default public InspectContainerResponse getCurrentContainerInfo() {
        return DockerClientFactory.instance().client().inspectContainerCmd(this.getContainerId()).exec();
    }

    default public Integer getFirstMappedPort() {
        return this.getExposedPorts().stream().findFirst().map(this::getMappedPort).orElseThrow(() -> new IllegalStateException("Container doesn't expose any ports"));
    }

    default public Integer getMappedPort(int originalPort) {
        Preconditions.checkState(this.getContainerId() != null, "Mapped port can only be obtained after the container is started");
        Ports.Binding[] binding = new Ports.Binding[]{};
        InspectContainerResponse containerInfo = this.getContainerInfo();
        if (containerInfo != null) {
            binding = (Ports.Binding[])containerInfo.getNetworkSettings().getPorts().getBindings().get(new ExposedPort(originalPort));
        }
        if (binding != null && binding.length > 0 && binding[0] != null) {
            return Integer.valueOf(binding[0].getHostPortSpec());
        }
        throw new IllegalArgumentException("Requested port (" + originalPort + ") is not mapped");
    }

    public List<Integer> getExposedPorts();

    default public List<String> getPortBindings() {
        ArrayList<String> portBindings = new ArrayList<String>();
        Ports hostPortBindings = this.getContainerInfo().getHostConfig().getPortBindings();
        for (Map.Entry binding : hostPortBindings.getBindings().entrySet()) {
            for (Ports.Binding portBinding : (Ports.Binding[])binding.getValue()) {
                portBindings.add(String.format("%s:%s", portBinding.toString(), binding.getKey()));
            }
        }
        return portBindings;
    }

    default public List<Integer> getBoundPortNumbers() {
        return this.getPortBindings().stream().map(PortBinding::parse).map(PortBinding::getBinding).map(Ports.Binding::getHostPortSpec).filter(Objects::nonNull).map(Integer::valueOf).collect(Collectors.toList());
    }

    default public String getLogs() {
        return LogUtils.getOutput(DockerClientFactory.instance().client(), this.getContainerId(), new OutputFrame.OutputType[0]);
    }

    default public String getLogs(OutputFrame.OutputType ... types) {
        return LogUtils.getOutput(DockerClientFactory.instance().client(), this.getContainerId(), types);
    }

    default public String getContainerId() {
        return this.getContainerInfo().getId();
    }

    public InspectContainerResponse getContainerInfo();

    default public Container.ExecResult execInContainer(String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return this.execInContainer(StandardCharsets.UTF_8, command);
    }

    default public Container.ExecResult execInContainer(Charset outputCharset, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return ExecInContainerPattern.execInContainer(this.getContainerInfo(), outputCharset, command);
    }

    default public void copyFileToContainer(MountableFile mountableFile, String containerPath) {
        File sourceFile = new File(mountableFile.getResolvedPath());
        if (containerPath.endsWith("/") && sourceFile.isFile()) {
            Logger logger = LoggerFactory.getLogger(GenericContainer.class);
            logger.warn("folder-like containerPath in copyFileToContainer is deprecated, please explicitly specify a file path");
            this.copyFileToContainer((Transferable)mountableFile, containerPath + sourceFile.getName());
        } else {
            this.copyFileToContainer((Transferable)mountableFile, containerPath);
        }
    }

    default public void copyFileToContainer(Transferable transferable, String containerPath) {
        if (!this.isCreated()) {
            throw new IllegalStateException("copyFileToContainer can only be used with created / running container");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             TarArchiveOutputStream tarArchive = new TarArchiveOutputStream((OutputStream)byteArrayOutputStream);){
            tarArchive.setLongFileMode(3);
            transferable.transferTo(tarArchive, containerPath);
            tarArchive.finish();
            DockerClientFactory.instance().client().copyArchiveToContainerCmd(this.getContainerId()).withTarInputStream((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).withRemotePath("/").exec();
        }
    }

    default public void copyFileFromContainer(String containerPath, String destinationPath) throws IOException, InterruptedException {
        this.copyFileFromContainer(containerPath, (InputStream inputStream) -> {
            try (FileOutputStream output = new FileOutputStream(destinationPath);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)output);
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    /*
     * Exception decompiling
     */
    default public <T> T copyFileFromContainer(String containerPath, ThrowingFunction<InputStream, T> function) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

