/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CommitCmd;
import com.github.dockerjava.api.command.ConnectToNetworkCmd;
import com.github.dockerjava.api.command.ContainerDiffCmd;
import com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import com.github.dockerjava.api.command.CopyFileFromContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.CreateNetworkCmd;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.command.CreateSecretCmd;
import com.github.dockerjava.api.command.CreateServiceCmd;
import com.github.dockerjava.api.command.CreateVolumeCmd;
import com.github.dockerjava.api.command.DisconnectFromNetworkCmd;
import com.github.dockerjava.api.command.DockerCmdAsyncExec;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.DockerCmdSyncExec;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.command.InitializeSwarmCmd;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectExecCmd;
import com.github.dockerjava.api.command.InspectImageCmd;
import com.github.dockerjava.api.command.InspectNetworkCmd;
import com.github.dockerjava.api.command.InspectServiceCmd;
import com.github.dockerjava.api.command.InspectSwarmCmd;
import com.github.dockerjava.api.command.InspectVolumeCmd;
import com.github.dockerjava.api.command.JoinSwarmCmd;
import com.github.dockerjava.api.command.KillContainerCmd;
import com.github.dockerjava.api.command.LeaveSwarmCmd;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.ListNetworksCmd;
import com.github.dockerjava.api.command.ListSecretsCmd;
import com.github.dockerjava.api.command.ListServicesCmd;
import com.github.dockerjava.api.command.ListSwarmNodesCmd;
import com.github.dockerjava.api.command.ListTasksCmd;
import com.github.dockerjava.api.command.ListVolumesCmd;
import com.github.dockerjava.api.command.LoadImageCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.LogSwarmObjectCmd;
import com.github.dockerjava.api.command.PauseContainerCmd;
import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.api.command.PruneCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.api.command.RemoveNetworkCmd;
import com.github.dockerjava.api.command.RemoveSecretCmd;
import com.github.dockerjava.api.command.RemoveServiceCmd;
import com.github.dockerjava.api.command.RemoveVolumeCmd;
import com.github.dockerjava.api.command.RenameContainerCmd;
import com.github.dockerjava.api.command.ResizeContainerCmd;
import com.github.dockerjava.api.command.ResizeExecCmd;
import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.command.SaveImageCmd;
import com.github.dockerjava.api.command.SaveImagesCmd;
import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StatsCmd;
import com.github.dockerjava.api.command.StopContainerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerCmd;
import com.github.dockerjava.api.command.UnpauseContainerCmd;
import com.github.dockerjava.api.command.UpdateContainerCmd;
import com.github.dockerjava.api.command.UpdateServiceCmd;
import com.github.dockerjava.api.command.UpdateSwarmCmd;
import com.github.dockerjava.api.command.UpdateSwarmNodeCmd;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Identifier;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.PruneType;
import com.github.dockerjava.api.model.SecretSpec;
import com.github.dockerjava.api.model.ServiceSpec;
import com.github.dockerjava.api.model.SwarmSpec;
import com.github.dockerjava.transport.DockerHttpClient;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.testcontainers.shaded.com.github.dockerjava.core.DefaultDockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.DefaultDockerCmdExecFactory;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfigAware;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AttachContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AuthCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.BuildImageCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.CommitCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ConnectToNetworkCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ContainerDiffCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.CopyArchiveFromContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.CopyArchiveToContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.CopyFileFromContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.CreateContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.CreateImageCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.CreateNetworkCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.CreateSecretCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.CreateServiceCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.CreateVolumeCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.DisconnectFromNetworkCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.EventsCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ExecCreateCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ExecStartCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.InfoCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.InitializeSwarmCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.InpectNetworkCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.InspectContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.InspectExecCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.InspectImageCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.InspectServiceCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.InspectSwarmCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.InspectVolumeCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.JoinSwarmCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.KillContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.LeaveSwarmCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ListContainersCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ListImagesCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ListNetworksCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ListSecretsCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ListServicesCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ListSwarmNodesCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ListTasksCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ListVolumesCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.LoadImageCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.LogContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.LogSwarmObjectImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.PauseContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.PingCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.PruneCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.PullImageCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.PushImageCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.RemoveContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.RemoveImageCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.RemoveNetworkCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.RemoveSecretCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.RemoveServiceCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.RemoveVolumeCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.RenameContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ResizeContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.ResizeExecCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.RestartContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.SaveImageCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.SaveImagesCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.SearchImagesCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.StartContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.StatsCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.StopContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.TagImageCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.TopContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.UnpauseContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.UpdateContainerCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.UpdateServiceCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.UpdateSwarmCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.UpdateSwarmNodeCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.VersionCmdImpl;
import org.testcontainers.shaded.com.github.dockerjava.core.command.WaitContainerCmdImpl;
import org.testcontainers.shaded.com.google.common.base.Preconditions;

public class DockerClientImpl
implements Closeable,
DockerClient {
    private final DockerClientConfig dockerClientConfig;
    DockerCmdExecFactory dockerCmdExecFactory;

    DockerClientImpl(DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull(dockerClientConfig, "config was not specified");
        this.dockerClientConfig = dockerClientConfig;
    }

    @Deprecated
    public static DockerClientImpl getInstance() {
        return new DockerClientImpl(DefaultDockerClientConfig.createDefaultConfigBuilder().build());
    }

    @Deprecated
    public static DockerClientImpl getInstance(DockerClientConfig dockerClientConfig) {
        return new DockerClientImpl(dockerClientConfig);
    }

    public static DockerClient getInstance(DockerClientConfig dockerClientConfig, DockerHttpClient dockerHttpClient) {
        return new DockerClientImpl(dockerClientConfig).withHttpClient(dockerHttpClient);
    }

    @Deprecated
    public static DockerClientImpl getInstance(String serverUrl) {
        return new DockerClientImpl(DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(serverUrl).build());
    }

    DockerClientImpl withHttpClient(DockerHttpClient httpClient) {
        return this.withDockerCmdExecFactory(new DefaultDockerCmdExecFactory(httpClient, this.dockerClientConfig.getObjectMapper()));
    }

    @Nullable
    public DockerHttpClient getHttpClient() {
        if (this.dockerCmdExecFactory instanceof DefaultDockerCmdExecFactory) {
            return ((DefaultDockerCmdExecFactory)this.dockerCmdExecFactory).getDockerHttpClient();
        }
        return null;
    }

    @Deprecated
    public DockerClientImpl withDockerCmdExecFactory(DockerCmdExecFactory dockerCmdExecFactory) {
        Preconditions.checkNotNull(dockerCmdExecFactory, "dockerCmdExecFactory was not specified");
        this.dockerCmdExecFactory = dockerCmdExecFactory;
        if (dockerCmdExecFactory instanceof DockerClientConfigAware) {
            ((DockerClientConfigAware)dockerCmdExecFactory).init(this.dockerClientConfig);
        }
        return this;
    }

    @Deprecated
    private DockerCmdExecFactory getDockerCmdExecFactory() {
        Preconditions.checkNotNull(this.dockerCmdExecFactory, "dockerCmdExecFactory was not specified");
        return this.dockerCmdExecFactory;
    }

    public AuthConfig authConfig() {
        Preconditions.checkNotNull(this.dockerClientConfig.getRegistryUsername(), "Configured username is null.");
        Preconditions.checkNotNull(this.dockerClientConfig.getRegistryUrl(), "Configured serverAddress is null.");
        return new AuthConfig().withUsername(this.dockerClientConfig.getRegistryUsername()).withPassword(this.dockerClientConfig.getRegistryPassword()).withEmail(this.dockerClientConfig.getRegistryEmail()).withRegistryAddress(this.dockerClientConfig.getRegistryUrl());
    }

    public AuthCmd authCmd() {
        return new AuthCmdImpl(this.getDockerCmdExecFactory().createAuthCmdExec(), this.authConfig());
    }

    public InfoCmd infoCmd() {
        return new InfoCmdImpl(this.getDockerCmdExecFactory().createInfoCmdExec());
    }

    public PingCmd pingCmd() {
        return new PingCmdImpl(this.getDockerCmdExecFactory().createPingCmdExec());
    }

    public VersionCmd versionCmd() {
        return new VersionCmdImpl(this.getDockerCmdExecFactory().createVersionCmdExec());
    }

    public PullImageCmd pullImageCmd(String repository) {
        return new PullImageCmdImpl(this.getDockerCmdExecFactory().createPullImageCmdExec(), this.dockerClientConfig.effectiveAuthConfig(repository), repository);
    }

    public PushImageCmd pushImageCmd(String name) {
        PushImageCmdImpl cmd = new PushImageCmdImpl(this.getDockerCmdExecFactory().createPushImageCmdExec(), this.dockerClientConfig.effectiveAuthConfig(name), name);
        return cmd;
    }

    public PushImageCmd pushImageCmd(Identifier identifier) {
        AuthConfig cfg;
        PushImageCmd cmd = this.pushImageCmd(identifier.repository.name);
        if (identifier.tag.isPresent()) {
            cmd.withTag((String)identifier.tag.get());
        }
        if ((cfg = this.dockerClientConfig.effectiveAuthConfig(identifier.repository.name)) != null) {
            cmd.withAuthConfig(cfg);
        }
        return cmd;
    }

    public SaveImageCmd saveImageCmd(String name) {
        return new SaveImageCmdImpl(this.getDockerCmdExecFactory().createSaveImageCmdExec(), name);
    }

    public SaveImagesCmd saveImagesCmd() {
        return new SaveImagesCmdImpl(this.getDockerCmdExecFactory().createSaveImagesCmdExec());
    }

    public CreateImageCmd createImageCmd(String repository, InputStream imageStream) {
        return new CreateImageCmdImpl(this.getDockerCmdExecFactory().createCreateImageCmdExec(), repository, imageStream);
    }

    public LoadImageCmd loadImageCmd(@Nonnull InputStream imageStream) {
        return new LoadImageCmdImpl(this.getDockerCmdExecFactory().createLoadImageCmdExec(), imageStream);
    }

    public SearchImagesCmd searchImagesCmd(String term) {
        return new SearchImagesCmdImpl(this.getDockerCmdExecFactory().createSearchImagesCmdExec(), term);
    }

    public RemoveImageCmd removeImageCmd(String imageId) {
        return new RemoveImageCmdImpl(this.getDockerCmdExecFactory().createRemoveImageCmdExec(), imageId);
    }

    public ListImagesCmd listImagesCmd() {
        return new ListImagesCmdImpl(this.getDockerCmdExecFactory().createListImagesCmdExec());
    }

    public InspectImageCmd inspectImageCmd(String imageId) {
        return new InspectImageCmdImpl(this.getDockerCmdExecFactory().createInspectImageCmdExec(), imageId);
    }

    public ListContainersCmd listContainersCmd() {
        return new ListContainersCmdImpl(this.getDockerCmdExecFactory().createListContainersCmdExec());
    }

    public CreateContainerCmd createContainerCmd(String image) {
        return new CreateContainerCmdImpl(this.getDockerCmdExecFactory().createCreateContainerCmdExec(), this.dockerClientConfig.effectiveAuthConfig(image), image);
    }

    public StartContainerCmd startContainerCmd(String containerId) {
        return new StartContainerCmdImpl(this.getDockerCmdExecFactory().createStartContainerCmdExec(), containerId);
    }

    public InspectContainerCmd inspectContainerCmd(String containerId) {
        return new InspectContainerCmdImpl(this.getDockerCmdExecFactory().createInspectContainerCmdExec(), containerId);
    }

    public ExecCreateCmd execCreateCmd(String containerId) {
        return new ExecCreateCmdImpl(this.getDockerCmdExecFactory().createExecCmdExec(), containerId);
    }

    public ResizeExecCmd resizeExecCmd(@Nonnull String execId) {
        return new ResizeExecCmdImpl(this.getDockerCmdExecFactory().createResizeExecCmdExec(), execId);
    }

    public RemoveContainerCmd removeContainerCmd(String containerId) {
        return new RemoveContainerCmdImpl(this.getDockerCmdExecFactory().createRemoveContainerCmdExec(), containerId);
    }

    public WaitContainerCmd waitContainerCmd(String containerId) {
        return new WaitContainerCmdImpl(this.getDockerCmdExecFactory().createWaitContainerCmdExec(), containerId);
    }

    public AttachContainerCmd attachContainerCmd(String containerId) {
        return new AttachContainerCmdImpl(this.getDockerCmdExecFactory().createAttachContainerCmdExec(), containerId);
    }

    public ExecStartCmd execStartCmd(String execId) {
        return new ExecStartCmdImpl(this.getDockerCmdExecFactory().createExecStartCmdExec(), execId);
    }

    public InspectExecCmd inspectExecCmd(String execId) {
        return new InspectExecCmdImpl(this.getDockerCmdExecFactory().createInspectExecCmdExec(), execId);
    }

    public LogContainerCmd logContainerCmd(String containerId) {
        return new LogContainerCmdImpl(this.getDockerCmdExecFactory().createLogContainerCmdExec(), containerId);
    }

    public CopyFileFromContainerCmd copyFileFromContainerCmd(String containerId, String resource) {
        return new CopyFileFromContainerCmdImpl(this.getDockerCmdExecFactory().createCopyFileFromContainerCmdExec(), containerId, resource);
    }

    public CopyArchiveFromContainerCmd copyArchiveFromContainerCmd(String containerId, String resource) {
        return new CopyArchiveFromContainerCmdImpl(this.getDockerCmdExecFactory().createCopyArchiveFromContainerCmdExec(), containerId, resource);
    }

    public CopyArchiveToContainerCmd copyArchiveToContainerCmd(String containerId) {
        return new CopyArchiveToContainerCmdImpl(this.getDockerCmdExecFactory().createCopyArchiveToContainerCmdExec(), containerId);
    }

    public ContainerDiffCmd containerDiffCmd(String containerId) {
        return new ContainerDiffCmdImpl(this.getDockerCmdExecFactory().createContainerDiffCmdExec(), containerId);
    }

    public StopContainerCmd stopContainerCmd(String containerId) {
        return new StopContainerCmdImpl(this.getDockerCmdExecFactory().createStopContainerCmdExec(), containerId);
    }

    public KillContainerCmd killContainerCmd(String containerId) {
        return new KillContainerCmdImpl(this.getDockerCmdExecFactory().createKillContainerCmdExec(), containerId);
    }

    public UpdateContainerCmd updateContainerCmd(@Nonnull String containerId) {
        return new UpdateContainerCmdImpl(this.getDockerCmdExecFactory().createUpdateContainerCmdExec(), containerId);
    }

    public RenameContainerCmd renameContainerCmd(@Nonnull String containerId) {
        return new RenameContainerCmdImpl(this.getDockerCmdExecFactory().createRenameContainerCmdExec(), containerId);
    }

    public RestartContainerCmd restartContainerCmd(String containerId) {
        return new RestartContainerCmdImpl(this.getDockerCmdExecFactory().createRestartContainerCmdExec(), containerId);
    }

    public ResizeContainerCmd resizeContainerCmd(@Nonnull String containerId) {
        return new ResizeContainerCmdImpl(this.getDockerCmdExecFactory().createResizeContainerCmdExec(), containerId);
    }

    public CommitCmd commitCmd(String containerId) {
        return new CommitCmdImpl(this.getDockerCmdExecFactory().createCommitCmdExec(), containerId);
    }

    public BuildImageCmd buildImageCmd() {
        return new BuildImageCmdImpl(this.getDockerCmdExecFactory().createBuildImageCmdExec());
    }

    public BuildImageCmd buildImageCmd(File dockerFileOrFolder) {
        return new BuildImageCmdImpl(this.getDockerCmdExecFactory().createBuildImageCmdExec(), dockerFileOrFolder);
    }

    public BuildImageCmd buildImageCmd(InputStream tarInputStream) {
        return new BuildImageCmdImpl(this.getDockerCmdExecFactory().createBuildImageCmdExec(), tarInputStream);
    }

    public TopContainerCmd topContainerCmd(String containerId) {
        return new TopContainerCmdImpl(this.getDockerCmdExecFactory().createTopContainerCmdExec(), containerId);
    }

    public TagImageCmd tagImageCmd(String imageId, String imageNameWithRepository, String tag) {
        return new TagImageCmdImpl(this.getDockerCmdExecFactory().createTagImageCmdExec(), imageId, imageNameWithRepository, tag);
    }

    public PauseContainerCmd pauseContainerCmd(String containerId) {
        return new PauseContainerCmdImpl(this.getDockerCmdExecFactory().createPauseContainerCmdExec(), containerId);
    }

    public UnpauseContainerCmd unpauseContainerCmd(String containerId) {
        return new UnpauseContainerCmdImpl(this.getDockerCmdExecFactory().createUnpauseContainerCmdExec(), containerId);
    }

    public EventsCmd eventsCmd() {
        return new EventsCmdImpl(this.getDockerCmdExecFactory().createEventsCmdExec());
    }

    public StatsCmd statsCmd(String containerId) {
        return new StatsCmdImpl(this.getDockerCmdExecFactory().createStatsCmdExec(), containerId);
    }

    public CreateVolumeCmd createVolumeCmd() {
        return new CreateVolumeCmdImpl(this.getDockerCmdExecFactory().createCreateVolumeCmdExec());
    }

    public InspectVolumeCmd inspectVolumeCmd(String name) {
        return new InspectVolumeCmdImpl(this.getDockerCmdExecFactory().createInspectVolumeCmdExec(), name);
    }

    public RemoveVolumeCmd removeVolumeCmd(String name) {
        return new RemoveVolumeCmdImpl(this.getDockerCmdExecFactory().createRemoveVolumeCmdExec(), name);
    }

    public ListVolumesCmd listVolumesCmd() {
        return new ListVolumesCmdImpl(this.getDockerCmdExecFactory().createListVolumesCmdExec());
    }

    public ListNetworksCmd listNetworksCmd() {
        return new ListNetworksCmdImpl(this.getDockerCmdExecFactory().createListNetworksCmdExec());
    }

    public InspectNetworkCmd inspectNetworkCmd() {
        return new InpectNetworkCmdImpl((DockerCmdSyncExec<InspectNetworkCmd, Network>)this.getDockerCmdExecFactory().createInspectNetworkCmdExec());
    }

    public CreateNetworkCmd createNetworkCmd() {
        return new CreateNetworkCmdImpl((DockerCmdSyncExec<CreateNetworkCmd, CreateNetworkResponse>)this.getDockerCmdExecFactory().createCreateNetworkCmdExec());
    }

    public RemoveNetworkCmd removeNetworkCmd(String networkId) {
        return new RemoveNetworkCmdImpl((DockerCmdSyncExec<RemoveNetworkCmd, Void>)this.getDockerCmdExecFactory().createRemoveNetworkCmdExec(), networkId);
    }

    public ConnectToNetworkCmd connectToNetworkCmd() {
        return new ConnectToNetworkCmdImpl((DockerCmdSyncExec<ConnectToNetworkCmd, Void>)this.getDockerCmdExecFactory().createConnectToNetworkCmdExec());
    }

    public DisconnectFromNetworkCmd disconnectFromNetworkCmd() {
        return new DisconnectFromNetworkCmdImpl((DockerCmdSyncExec<DisconnectFromNetworkCmd, Void>)this.getDockerCmdExecFactory().createDisconnectFromNetworkCmdExec());
    }

    public InitializeSwarmCmd initializeSwarmCmd(SwarmSpec swarmSpec) {
        return new InitializeSwarmCmdImpl(this.getDockerCmdExecFactory().createInitializeSwarmCmdExec(), swarmSpec);
    }

    public InspectSwarmCmd inspectSwarmCmd() {
        return new InspectSwarmCmdImpl(this.getDockerCmdExecFactory().createInspectSwarmCmdExec());
    }

    public JoinSwarmCmd joinSwarmCmd() {
        return new JoinSwarmCmdImpl(this.getDockerCmdExecFactory().createJoinSwarmCmdExec());
    }

    public LeaveSwarmCmd leaveSwarmCmd() {
        return new LeaveSwarmCmdImpl(this.getDockerCmdExecFactory().createLeaveSwarmCmdExec());
    }

    public UpdateSwarmCmd updateSwarmCmd(SwarmSpec swarmSpec) {
        return new UpdateSwarmCmdImpl(this.getDockerCmdExecFactory().createUpdateSwarmCmdExec(), swarmSpec);
    }

    public UpdateSwarmNodeCmd updateSwarmNodeCmd() {
        return new UpdateSwarmNodeCmdImpl(this.getDockerCmdExecFactory().updateSwarmNodeCmdExec());
    }

    public ListSwarmNodesCmd listSwarmNodesCmd() {
        return new ListSwarmNodesCmdImpl(this.getDockerCmdExecFactory().listSwarmNodeCmdExec());
    }

    public ListServicesCmd listServicesCmd() {
        return new ListServicesCmdImpl(this.getDockerCmdExecFactory().createListServicesCmdExec());
    }

    public CreateServiceCmd createServiceCmd(ServiceSpec serviceSpec) {
        return new CreateServiceCmdImpl(this.getDockerCmdExecFactory().createCreateServiceCmdExec(), serviceSpec);
    }

    public InspectServiceCmd inspectServiceCmd(String serviceId) {
        return new InspectServiceCmdImpl(this.getDockerCmdExecFactory().createInspectServiceCmdExec(), serviceId);
    }

    public UpdateServiceCmd updateServiceCmd(String serviceId, ServiceSpec serviceSpec) {
        return new UpdateServiceCmdImpl(this.getDockerCmdExecFactory().createUpdateServiceCmdExec(), serviceId, serviceSpec);
    }

    public RemoveServiceCmd removeServiceCmd(String serviceId) {
        return new RemoveServiceCmdImpl(this.getDockerCmdExecFactory().createRemoveServiceCmdExec(), serviceId);
    }

    public LogSwarmObjectCmd logServiceCmd(String serviceId) {
        return new LogSwarmObjectImpl((DockerCmdAsyncExec<LogSwarmObjectCmd, Frame>)this.getDockerCmdExecFactory().logSwarmObjectExec("services"), serviceId);
    }

    public LogSwarmObjectCmd logTaskCmd(String taskId) {
        return new LogSwarmObjectImpl((DockerCmdAsyncExec<LogSwarmObjectCmd, Frame>)this.getDockerCmdExecFactory().logSwarmObjectExec("tasks"), taskId);
    }

    public PruneCmd pruneCmd(PruneType pruneType) {
        return new PruneCmdImpl(this.getDockerCmdExecFactory().pruneCmdExec(), pruneType);
    }

    public ListSecretsCmd listSecretsCmd() {
        return new ListSecretsCmdImpl(this.getDockerCmdExecFactory().createListSecretsCmdExec());
    }

    public CreateSecretCmd createSecretCmd(SecretSpec secretSpec) {
        return new CreateSecretCmdImpl(this.getDockerCmdExecFactory().createCreateSecretCmdExec(), secretSpec);
    }

    public RemoveSecretCmd removeSecretCmd(String secretId) {
        return new RemoveSecretCmdImpl(this.getDockerCmdExecFactory().createRemoveSecretCmdExec(), secretId);
    }

    public ListTasksCmd listTasksCmd() {
        return new ListTasksCmdImpl(this.getDockerCmdExecFactory().listTasksCmdExec());
    }

    @Override
    public void close() throws IOException {
        this.getDockerCmdExecFactory().close();
    }
}

