/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class ConfidentialClientAcceptExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfigurationRepresentation> {
    protected final KeycloakSession session;

    public ConfidentialClientAcceptExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "confidential-client";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: 
            case TOKEN_REQUEST: {
                this.checkIsConfidentialClient();
                return;
            }
        }
    }

    private void checkIsConfidentialClient() throws ClientPolicyException {
        ClientModel client = this.session.getContext().getClient();
        if (client == null) {
            throw new ClientPolicyException("invalid_client", "invalid client access type");
        }
        if (client.isPublicClient()) {
            throw new ClientPolicyException("invalid_client", "invalid client access type");
        }
        if (client.isBearerOnly()) {
            throw new ClientPolicyException("invalid_client", "invalid client access type");
        }
    }
}

