/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureClientAuthenticatorExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(SecureClientAuthenticatorExecutor.class);
    private final KeycloakSession session;
    private Configuration configuration;

    public SecureClientAuthenticatorExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "secure-client-authenticator";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: {
                ClientCRUDContext clientUpdateContext = (ClientCRUDContext)context;
                this.autoConfigure(clientUpdateContext.getProposedClientRepresentation());
                this.validateDuringClientCRUD(clientUpdateContext.getProposedClientRepresentation());
                break;
            }
            case TOKEN_REQUEST: 
            case TOKEN_REFRESH: 
            case TOKEN_REVOKE: 
            case TOKEN_INTROSPECT: 
            case LOGOUT_REQUEST: {
                this.validateDuringClientRequest();
            }
            default: {
                return;
            }
        }
    }

    private void autoConfigure(ClientRepresentation rep) {
        String defaultClientAuthenticator = this.configuration.getDefaultClientAuthenticator();
        if (defaultClientAuthenticator != null) {
            if (rep.getClientAuthenticatorType() == null) {
                logger.tracef("Set default client authenticator %s on client %s", (Object)defaultClientAuthenticator, (Object)rep.getClientId());
                rep.setClientAuthenticatorType(defaultClientAuthenticator);
            } else {
                logger.tracef("Skip setting default client authenticator on client %s. Client authenticator already set to %s", (Object)rep.getClientId(), (Object)rep.getClientAuthenticatorType());
            }
        }
    }

    private void validateDuringClientCRUD(ClientRepresentation rep) throws ClientPolicyException {
        if (rep.isPublicClient() != null && rep.isPublicClient().booleanValue()) {
            return;
        }
        String clientAuthenticatorType = rep.getClientAuthenticatorType();
        if (this.isValidClientAuthenticator(clientAuthenticatorType)) {
            return;
        }
        throw new ClientPolicyException("invalid_client_metadata", "Invalid client metadata: token_endpoint_auth_method");
    }

    private void validateDuringClientRequest() throws ClientPolicyException {
        ClientModel client = this.session.getContext().getClient();
        if (client.isPublicClient()) {
            return;
        }
        if (this.isValidClientAuthenticator(client.getClientAuthenticatorType())) {
            return;
        }
        logger.warnf("Client authentication method not allowed for client: %s", (Object)client.getClientId());
        throw new ClientPolicyException("invalid_request", "Configured client authentication method not allowed for client");
    }

    private boolean isValidClientAuthenticator(String clientAuthenticatorType) {
        List<String> acceptableClientAuthn = this.configuration.getAllowedClientAuthenticators();
        return acceptableClientAuthn != null && acceptableClientAuthn.stream().anyMatch(i -> i.equals(clientAuthenticatorType));
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="allowed-client-authenticators")
        protected List<String> allowedClientAuthenticators;
        @JsonProperty(value="default-client-authenticator")
        protected String defaultClientAuthenticator;

        public List<String> getAllowedClientAuthenticators() {
            return this.allowedClientAuthenticators;
        }

        public void setAllowedClientAuthenticators(List<String> allowedClientAuthenticators) {
            this.allowedClientAuthenticators = allowedClientAuthenticators;
        }

        public String getDefaultClientAuthenticator() {
            return this.defaultClientAuthenticator;
        }

        public void setDefaultClientAuthenticator(String defaultClientAuthenticator) {
            this.defaultClientAuthenticator = defaultClientAuthenticator;
        }
    }
}

