/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.config.DeclarativeAttributes;
import org.keycloak.userprofile.config.DeclarativeUserProfileModel;
import org.keycloak.userprofile.config.UPAttribute;
import org.keycloak.userprofile.config.UPAttributePermissions;
import org.keycloak.userprofile.config.UPAttributeRequired;
import org.keycloak.userprofile.config.UPConfig;
import org.keycloak.userprofile.config.UPConfigUtils;
import org.keycloak.userprofile.legacy.AbstractUserProfileProvider;
import org.keycloak.validate.ValidatorConfig;

public class DeclarativeUserProfileProvider
extends AbstractUserProfileProvider<DeclarativeUserProfileProvider>
implements AmphibianProviderFactory<DeclarativeUserProfileProvider>,
EnvironmentDependentProviderFactory {
    public static final String SYSTEM_DEFAULT_CONFIG_RESOURCE = "keycloak-default-user-profile.json";
    public static final String ID = "declarative-user-profile";
    public static final String UP_PIECES_COUNT_COMPONENT_CONFIG_KEY = "config-pieces-count";
    private static final String PARSED_CONFIG_COMPONENT_KEY = "kc.user.profile.metadata";
    private static final String UP_PIECE_COMPONENT_CONFIG_KEY_BASE = "config-piece-";
    private String defaultRawConfig;

    private static boolean createRequiredForScopePredicate(AttributeContext context, List<String> requiredScopes) {
        KeycloakSession session = context.getSession();
        AuthenticationSessionModel authenticationSession = session.getContext().getAuthenticationSession();
        if (authenticationSession == null) {
            return false;
        }
        String requestedScopesString = authenticationSession.getClientNote("scope");
        ClientModel client = authenticationSession.getClient();
        return TokenManager.getRequestedClientScopes(requestedScopesString, client).map(csm -> csm.getName()).anyMatch(requiredScopes::contains);
    }

    public DeclarativeUserProfileProvider() {
    }

    public DeclarativeUserProfileProvider(KeycloakSession session, Map<UserProfileContext, UserProfileMetadata> metadataRegistry, String defaultRawConfig) {
        super(session, metadataRegistry);
        this.defaultRawConfig = defaultRawConfig;
    }

    public String getId() {
        return ID;
    }

    @Override
    protected DeclarativeUserProfileProvider create(KeycloakSession session, Map<UserProfileContext, UserProfileMetadata> metadataRegistry) {
        return new DeclarativeUserProfileProvider(session, metadataRegistry, this.defaultRawConfig);
    }

    @Override
    protected Attributes createAttributes(UserProfileContext context, Map<String, ?> attributes, UserModel user, UserProfileMetadata metadata) {
        return new DeclarativeAttributes(context, attributes, user, metadata, this.session);
    }

    @Override
    protected UserProfileMetadata configureUserProfile(UserProfileMetadata metadata, KeycloakSession session) {
        ComponentModel model = this.getComponentModelOrCreate(session);
        HashMap<UserProfileContext, UserProfileMetadata> metadataMap = (HashMap<UserProfileContext, UserProfileMetadata>)model.getNote(PARSED_CONFIG_COMPONENT_KEY);
        if (metadataMap == null) {
            metadataMap = new HashMap<UserProfileContext, UserProfileMetadata>();
            model.setNote(PARSED_CONFIG_COMPONENT_KEY, metadataMap);
        }
        return metadataMap.computeIfAbsent(metadata.getContext(), context -> this.decorateUserProfileForCache(metadata, model));
    }

    public String getHelpText() {
        return null;
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        String upConfigJson = this.getConfigJsonFromComponentModel(model);
        if (!ObjectUtil.isBlank((CharSequence)upConfigJson)) {
            try {
                UPConfig upc = UPConfigUtils.readConfig(new ByteArrayInputStream(upConfigJson.getBytes("UTF-8")));
                List<String> errors = UPConfigUtils.validate(session, upc);
                if (!errors.isEmpty()) {
                    throw new ComponentValidationException(errors.toString(), new Object[0]);
                }
            }
            catch (IOException e) {
                throw new ComponentValidationException(e.getMessage(), (Throwable)e);
            }
        }
        if (model != null) {
            model.removeNote(PARSED_CONFIG_COMPONENT_KEY);
        }
    }

    @Override
    public String getConfiguration() {
        String cfg = this.getConfigJsonFromComponentModel(this.getComponentModel());
        if (ObjectUtil.isBlank((CharSequence)cfg)) {
            return this.defaultRawConfig;
        }
        return cfg;
    }

    @Override
    public void setConfiguration(String configuration) {
        ComponentModel component = this.getComponentModel();
        this.removeConfigJsonFromComponentModel(component);
        if (!ObjectUtil.isBlank((CharSequence)configuration)) {
            List<String> parts = UPConfigUtils.getChunks(configuration, 3800);
            MultivaluedHashMap config = component.getConfig();
            config.putSingle((Object)UP_PIECES_COUNT_COMPONENT_CONFIG_KEY, (Object)("" + parts.size()));
            int i = 0;
            for (String part : parts) {
                config.putSingle((Object)(UP_PIECE_COMPONENT_CONFIG_KEY_BASE + i++), (Object)part);
            }
        }
        this.session.getContext().getRealm().updateComponent(component);
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        try (InputStream is = this.getClass().getResourceAsStream(SYSTEM_DEFAULT_CONFIG_RESOURCE);){
            this.defaultRawConfig = StreamUtil.readString((InputStream)is, (Charset)Charset.defaultCharset());
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to load default user profile config file", cause);
        }
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }

    public ComponentModel getComponentModel() {
        return this.getComponentModelOrCreate(this.session);
    }

    protected UserProfileMetadata decorateUserProfileForCache(UserProfileMetadata metadata, ComponentModel model) {
        UserProfileContext context = metadata.getContext();
        UPConfig parsedConfig = this.getParsedConfig(model);
        if (parsedConfig == null || context == UserProfileContext.REGISTRATION_USER_CREATION) {
            return metadata;
        }
        UserProfileMetadata decoratedMetadata = metadata.clone();
        for (UPAttribute attrConfig : parsedConfig.getAttributes()) {
            String attributeName = attrConfig.getName();
            ArrayList<AttributeValidatorMetadata> validators = new ArrayList<AttributeValidatorMetadata>();
            Map<String, Map<String, Object>> validationsConfig = attrConfig.getValidations();
            if (validationsConfig != null) {
                for (Map.Entry<String, Map<String, Object>> vc : validationsConfig.entrySet()) {
                    validators.add(this.createConfiguredValidator(vc.getKey(), vc.getValue()));
                }
            }
            UPAttributeRequired rc = attrConfig.getRequired();
            Predicate<AttributeContext> required = AttributeMetadata.ALWAYS_FALSE;
            if (rc != null && !"username".equals(attributeName) && !"email".equals(attributeName)) {
                if (rc.isAlways() || UPConfigUtils.isRoleForContext(context, rc.getRoles())) {
                    required = AttributeMetadata.ALWAYS_TRUE;
                } else if (UPConfigUtils.canBeAuthFlowContext(context) && rc.getScopes() != null && !rc.getScopes().isEmpty()) {
                    required = c -> DeclarativeUserProfileProvider.createRequiredForScopePredicate(c, rc.getScopes());
                }
                validators.add(new AttributeValidatorMetadata("up-attribute-required-by-metadata-value"));
            }
            Predicate writeAllowed = AttributeMetadata.ALWAYS_FALSE;
            Predicate<Object> readAllowed = AttributeMetadata.ALWAYS_FALSE;
            UPAttributePermissions permissions = attrConfig.getPermissions();
            if (permissions != null) {
                List<String> viewRoles;
                List<String> editRoles = permissions.getEdit();
                if (!editRoles.isEmpty()) {
                    writeAllowed = ac -> UPConfigUtils.isRoleForContext(ac.getContext(), editRoles);
                }
                readAllowed = (viewRoles = permissions.getView()).isEmpty() ? writeAllowed : this.createViewAllowedPredicate(writeAllowed, viewRoles);
            }
            Map<String, Object> annotations = attrConfig.getAnnotations();
            if ("username".equals(attributeName) || "email".equals(attributeName)) {
                List atts;
                if (permissions == null) {
                    writeAllowed = AttributeMetadata.ALWAYS_TRUE;
                }
                if ((atts = decoratedMetadata.getAttribute(attributeName)).isEmpty()) {
                    decoratedMetadata.addAttribute(attributeName, writeAllowed, validators).addAnnotations(annotations);
                    continue;
                }
                atts.stream().forEach(c -> c.addValidator(validators).addAnnotations(annotations));
                continue;
            }
            validators.add(new AttributeValidatorMetadata("up-immutable-attribute"));
            decoratedMetadata.addAttribute(attributeName, validators, writeAllowed, required, readAllowed).addAnnotations(annotations);
        }
        return decoratedMetadata;
    }

    private Predicate<AttributeContext> createViewAllowedPredicate(Predicate<AttributeContext> canEdit, List<String> viewRoles) {
        return ac -> UPConfigUtils.isRoleForContext(ac.getContext(), viewRoles) || canEdit.test((AttributeContext)ac);
    }

    protected UPConfig getParsedConfig(ComponentModel model) {
        String rawConfig = this.getConfigJsonFromComponentModel(model);
        if (!ObjectUtil.isBlank((CharSequence)rawConfig)) {
            try {
                UPConfig upc = UPConfigUtils.readConfig(new ByteArrayInputStream(rawConfig.getBytes("UTF-8")));
                List<String> errors = UPConfigUtils.validate(this.session, upc);
                if (!errors.isEmpty()) {
                    throw new RuntimeException("UserProfile configuration for realm '" + this.session.getContext().getRealm().getName() + "' is invalid: " + errors.toString());
                }
                return upc;
            }
            catch (IOException e) {
                throw new RuntimeException("UserProfile configuration for realm '" + this.session.getContext().getRealm().getName() + "' is invalid:" + e.getMessage(), e);
            }
        }
        return null;
    }

    private ComponentModel getComponentModelOrCreate(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        return realm.getComponentsStream(realm.getId(), UserProfileProvider.class.getName()).findAny().orElseGet(() -> realm.addComponentModel((ComponentModel)new DeclarativeUserProfileModel()));
    }

    protected AttributeValidatorMetadata createConfiguredValidator(String validator, Map<String, Object> validatorConfig) {
        return new AttributeValidatorMetadata(validator, ValidatorConfig.builder().config(validatorConfig).config("ignore.empty.value", (Object)true).build());
    }

    private String getConfigJsonFromComponentModel(ComponentModel model) {
        if (model == null) {
            return null;
        }
        int count = model.get(UP_PIECES_COUNT_COMPONENT_CONFIG_KEY, 0);
        if (count < 1) {
            return this.defaultRawConfig;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            String v = model.get(UP_PIECE_COMPONENT_CONFIG_KEY_BASE + i);
            if (v == null) continue;
            sb.append(v);
        }
        return sb.toString();
    }

    private void removeConfigJsonFromComponentModel(ComponentModel model) {
        if (model == null) {
            return;
        }
        int count = model.get(UP_PIECES_COUNT_COMPONENT_CONFIG_KEY, 0);
        if (count < 1) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            model.getConfig().remove((Object)(UP_PIECE_COMPONENT_CONFIG_KEY_BASE + i));
        }
        model.getConfig().remove((Object)UP_PIECES_COUNT_COMPONENT_CONFIG_KEY);
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DECLARATIVE_USER_PROFILE);
    }
}

