/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class ImmutableAttributeValidator
implements SimpleValidator {
    public static final String ID = "up-immutable-attribute";
    private static final String DEFAULT_ERROR_MESSAGE = "error-user-attribute-read-only";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        List values;
        UserProfileAttributeValidationContext ac = (UserProfileAttributeValidationContext)context;
        AttributeContext attributeContext = ac.getAttributeContext();
        if (!this.isReadOnly(attributeContext)) {
            return context;
        }
        UserModel user = attributeContext.getUser();
        if (user == null) {
            return context;
        }
        List currentValue = user.getAttributeStream(inputHint).collect(Collectors.toList());
        if (!currentValue.containsAll(values = (List)input) || currentValue.size() != values.size()) {
            context.addError(new ValidationError(ID, inputHint, DEFAULT_ERROR_MESSAGE));
            return context;
        }
        return context;
    }

    private boolean isReadOnly(AttributeContext attributeContext) {
        return attributeContext.getMetadata().isReadOnly(attributeContext);
    }
}

