/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.function.Supplier;
import org.infinispan.commons.api.BasicCache;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.OAuth2DeviceTokenStoreProvider;
import org.keycloak.models.OAuth2DeviceTokenStoreProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanOAuth2DeviceTokenStoreProvider;
import org.keycloak.models.sessions.infinispan.InfinispanSingleUseTokenStoreProviderFactory;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanOAuth2DeviceTokenStoreProviderFactory
implements OAuth2DeviceTokenStoreProviderFactory {
    private volatile Supplier<BasicCache<String, ActionTokenValueEntity>> codeCache;

    public OAuth2DeviceTokenStoreProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanOAuth2DeviceTokenStoreProvider(session, this.codeCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.codeCache == null) {
            InfinispanOAuth2DeviceTokenStoreProviderFactory infinispanOAuth2DeviceTokenStoreProviderFactory = this;
            synchronized (infinispanOAuth2DeviceTokenStoreProviderFactory) {
                this.codeCache = InfinispanSingleUseTokenStoreProviderFactory.getActionTokenCache(session);
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }

    public int order() {
        return 1;
    }
}

