/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;

public class DefaultAttributes
extends HashMap<String, List<String>>
implements Attributes {
    public static final String READ_ONLY_ATTRIBUTE_KEY = "kc.read.only";
    private final UserProfileContext context;
    private final KeycloakSession session;
    private final Map<String, AttributeMetadata> metadataByAttribute;
    protected final UserModel user;

    public DefaultAttributes(UserProfileContext context, Map<String, ?> attributes, UserModel user, UserProfileMetadata profileMetadata, KeycloakSession session) {
        this.context = context;
        this.user = user;
        this.session = session;
        this.metadataByAttribute = this.configureMetadata(profileMetadata.getAttributes());
        this.putAll(Collections.unmodifiableMap(this.normalizeAttributes(attributes)));
    }

    @Override
    public boolean isReadOnly(String attributeName) {
        return this.isReadOnlyFromMetadata(attributeName) || this.isReadOnlyInternalAttribute(attributeName);
    }

    private boolean isReadOnlyFromMetadata(String attributeName) {
        AttributeMetadata attributeMetadata = this.metadataByAttribute.get(attributeName);
        if (attributeMetadata == null) {
            return false;
        }
        return attributeMetadata.isReadOnly(this.createAttributeContext(attributeMetadata));
    }

    @Override
    public boolean isRequired(String name) {
        AttributeMetadata attributeMetadata = this.metadataByAttribute.get(name);
        if (attributeMetadata == null) {
            return false;
        }
        return attributeMetadata.isRequired(this.createAttributeContext(attributeMetadata));
    }

    @Override
    public boolean validate(String name, Consumer<ValidationError> ... listeners) {
        AbstractMap.SimpleImmutableEntry<String, List<String>> attribute = this.createAttribute(name);
        ArrayList metadatas = new ArrayList();
        metadatas.addAll(Optional.ofNullable(this.metadataByAttribute.get(attribute.getKey())).map(Collections::singletonList).orElse(Collections.emptyList()));
        metadatas.addAll(Optional.ofNullable(this.metadataByAttribute.get(READ_ONLY_ATTRIBUTE_KEY)).map(Collections::singletonList).orElse(Collections.emptyList()));
        Boolean result = null;
        for (AttributeMetadata metadata : metadatas) {
            AttributeContext attributeContext = this.createAttributeContext(attribute, metadata);
            for (AttributeValidatorMetadata validator : metadata.getValidators()) {
                ValidationContext vc = validator.validate(attributeContext);
                if (vc.isValid()) continue;
                if (result == null) {
                    result = false;
                }
                if (listeners == null) continue;
                for (ValidationError error : vc.getErrors()) {
                    for (Consumer<ValidationError> consumer : listeners) {
                        consumer.accept(error);
                    }
                }
            }
        }
        return result == null;
    }

    @Override
    public List<String> getValues(String name) {
        return this.getOrDefault(name, EMPTY_VALUE);
    }

    @Override
    public boolean contains(String name) {
        return this.containsKey(name);
    }

    @Override
    public Set<String> nameSet() {
        return this.keySet();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> attributeSet() {
        return this.entrySet();
    }

    @Override
    public AttributeMetadata getMetadata(String name) {
        AttributeMetadata metadata = this.metadataByAttribute.get(name);
        if (metadata == null) {
            return null;
        }
        return metadata.clone();
    }

    @Override
    public Map<String, List<String>> getReadable() {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>(this.user.getAttributes());
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    @Override
    public Map<String, List<String>> toMap() {
        return this;
    }

    private AttributeContext createAttributeContext(Map.Entry<String, List<String>> attribute, AttributeMetadata metadata) {
        return new AttributeContext(this.context, this.session, attribute, this.user, metadata);
    }

    private AttributeContext createAttributeContext(String attributeName, AttributeMetadata metadata) {
        return new AttributeContext(this.context, this.session, this.createAttribute(attributeName), this.user, metadata);
    }

    protected AttributeContext createAttributeContext(AttributeMetadata metadata) {
        return this.createAttributeContext(this.createAttribute(metadata.getName()), metadata);
    }

    private Map<String, AttributeMetadata> configureMetadata(List<AttributeMetadata> attributes) {
        HashMap<String, AttributeMetadata> metadatas = new HashMap<String, AttributeMetadata>();
        for (AttributeMetadata metadata : attributes) {
            if (!metadata.isSelected(this.createAttributeContext(metadata))) continue;
            metadatas.put(metadata.getName(), metadata);
        }
        return metadatas;
    }

    private AbstractMap.SimpleImmutableEntry<String, List<String>> createAttribute(final String name) {
        return new AbstractMap.SimpleImmutableEntry<String, List<String>>(name, null){

            @Override
            public List<String> getValue() {
                List values = (List)DefaultAttributes.this.get(name);
                if (values == null) {
                    return Attributes.EMPTY_VALUE;
                }
                return values;
            }
        };
    }

    private Map<String, List<String>> normalizeAttributes(Map<String, ?> attributes) {
        List email;
        List username;
        HashMap<String, List<String>> newAttributes = new HashMap<String, List<String>>();
        RealmModel realm = this.session.getContext().getRealm();
        if (attributes != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                Object value;
                String key = (String)entry.getKey();
                if (!this.isSupportedAttribute(key)) continue;
                if (key.startsWith("user.attributes.")) {
                    key = key.substring("user.attributes.".length());
                }
                List<String> values = (value = entry.getValue()) instanceof String ? Collections.singletonList((String)value) : (List<String>)value;
                if (key.equals("username")) {
                    values = Collections.singletonList(values.get(0).toLowerCase());
                }
                newAttributes.put(key, Collections.unmodifiableList(values));
            }
        }
        for (String string : this.metadataByAttribute.keySet()) {
            if (!this.isSupportedAttribute(string) || newAttributes.containsKey(string)) continue;
            List values = EMPTY_VALUE;
            AttributeMetadata metadata = this.metadataByAttribute.get(string);
            if (this.user != null && !metadata.canView(this.createAttributeContext(metadata))) {
                values = (List)this.user.getAttributes().get(string);
            }
            newAttributes.put(string, values);
        }
        if (this.user != null && ((username = (List)newAttributes.get("username")) == null || username.isEmpty() || !realm.isEditUsernameAllowed() && UserProfileContext.USER_API.equals((Object)this.context))) {
            newAttributes.put("username", Collections.singletonList(this.user.getUsername()));
        }
        if ((email = (List)newAttributes.get("email")) != null && realm.isRegistrationEmailAsUsername()) {
            newAttributes.put("username", email);
        }
        return newAttributes;
    }

    private boolean isSupportedAttribute(String name) {
        if (READ_ONLY_ATTRIBUTE_KEY.equals(name)) {
            return false;
        }
        if (this.metadataByAttribute.containsKey(name)) {
            return true;
        }
        if (UserProfileContext.USER_API.equals((Object)this.context) || UserProfileContext.ACCOUNT.equals((Object)this.context)) {
            return true;
        }
        if (name.startsWith("user.attributes.")) {
            return true;
        }
        if (this.isReadOnly(name)) {
            return true;
        }
        return this.isRootAttribute(name);
    }

    private boolean isReadOnlyInternalAttribute(String attributeName) {
        AttributeMetadata readonlyMetadata = this.metadataByAttribute.get(READ_ONLY_ATTRIBUTE_KEY);
        if (readonlyMetadata == null) {
            return false;
        }
        AttributeContext attributeContext = this.createAttributeContext(attributeName, readonlyMetadata);
        for (AttributeValidatorMetadata validator : readonlyMetadata.getValidators()) {
            ValidationContext vc = validator.validate(attributeContext);
            if (vc.isValid()) continue;
            return true;
        }
        return false;
    }
}

