/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.utils.StringUtil;
import org.keycloak.validate.AbstractSimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidationResult;
import org.keycloak.validate.ValidatorConfig;

public abstract class AbstractNumberValidator
extends AbstractSimpleValidator
implements ConfiguredProvider {
    public static final String MESSAGE_INVALID_NUMBER = "error-invalid-number";
    public static final String MESSAGE_NUMBER_OUT_OF_RANGE = "error-number-out-of-range";
    public static final String KEY_MIN = "min";
    public static final String KEY_MAX = "max";
    private final ValidatorConfig defaultConfig;
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public AbstractNumberValidator() {
        this(ValidatorConfig.EMPTY);
    }

    public AbstractNumberValidator(ValidatorConfig config) {
        this.defaultConfig = config;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    @Override
    protected boolean skipValidation(Object value, ValidatorConfig config) {
        if (this.isIgnoreEmptyValuesConfigured(config) && (value == null || value instanceof String)) {
            return value == null || StringUtil.isBlank((String)value.toString());
        }
        return false;
    }

    @Override
    protected void doValidate(Object value, String inputHint, ValidationContext context, ValidatorConfig config) {
        if (config == null || config.isEmpty()) {
            config = this.defaultConfig;
        }
        Number number = null;
        if (value != null) {
            try {
                number = this.convert(value, config);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (number == null) {
            context.addError(new ValidationError(this.getId(), inputHint, MESSAGE_INVALID_NUMBER));
            return;
        }
        Number min = this.getMinMaxConfig(config, KEY_MIN);
        Number max = this.getMinMaxConfig(config, KEY_MAX);
        if (min != null && this.isFirstGreaterThanToSecond(min, number)) {
            context.addError(new ValidationError(this.getId(), inputHint, MESSAGE_NUMBER_OUT_OF_RANGE, min, max));
            return;
        }
        if (max != null && this.isFirstGreaterThanToSecond(number, max)) {
            context.addError(new ValidationError(this.getId(), inputHint, MESSAGE_NUMBER_OUT_OF_RANGE, min, max));
            return;
        }
    }

    @Override
    public ValidationResult validateConfig(KeycloakSession session, ValidatorConfig config) {
        ValidationResult s;
        LinkedHashSet<ValidationError> errors = new LinkedHashSet<ValidationError>();
        if (config != null) {
            boolean containsMin = config.containsKey(KEY_MIN);
            boolean containsMax = config.containsKey(KEY_MAX);
            Number min = this.getMinMaxConfig(config, KEY_MIN);
            Number max = this.getMinMaxConfig(config, KEY_MAX);
            if (containsMin && min == null) {
                errors.add(new ValidationError(this.getId(), KEY_MIN, "error-validator-config-invalid-number-value", config.get(KEY_MIN)));
            }
            if (containsMax && max == null) {
                errors.add(new ValidationError(this.getId(), KEY_MAX, "error-validator-config-invalid-number-value", config.get(KEY_MAX)));
            }
            if (errors.isEmpty() && containsMin && containsMax && !this.isFirstGreaterThanToSecond(max, min)) {
                errors.add(new ValidationError(this.getId(), KEY_MAX, "error-validator-config-invalid-value"));
            }
        }
        if (!(s = super.validateConfig(session, config)).isValid()) {
            errors.addAll(s.getErrors());
        }
        return new ValidationResult(errors);
    }

    protected abstract Number convert(Object var1, ValidatorConfig var2);

    protected abstract Number getMinMaxConfig(ValidatorConfig var1, String var2);

    protected abstract boolean isFirstGreaterThanToSecond(Number var1, Number var2);

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(KEY_MIN);
        property.setLabel("Minimum");
        property.setHelpText("The minimal allowed value - this config is optional.");
        property.setType("String");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(KEY_MAX);
        property.setLabel("Maximum");
        property.setHelpText("The maximal allowed value - this config is optional.");
        property.setType("String");
        configProperties.add(property);
    }
}

