/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.net;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.metrics.Measured;
import io.vertx.mutiny.core.net.NetSocket;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.ReadStream;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.core.net.NetServer.class)
public class NetServer
implements Measured {
    public static final TypeArg<NetServer> __TYPE_ARG = new TypeArg(obj -> new NetServer((io.vertx.core.net.NetServer)obj), NetServer::getDelegate);
    private final io.vertx.core.net.NetServer delegate;
    static final TypeArg<NetSocket> TYPE_ARG_0 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());

    public NetServer(io.vertx.core.net.NetServer delegate) {
        this.delegate = delegate;
    }

    NetServer() {
        this.delegate = null;
    }

    public io.vertx.core.net.NetServer getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetServer that = (NetServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public ReadStream<NetSocket> connectStream() {
        ReadStream<NetSocket> ret = ReadStream.newInstance(this.delegate.connectStream(), TYPE_ARG_0);
        return ret;
    }

    private NetServer __connectHandler(final Handler<NetSocket> handler) {
        NetServer ret = NetServer.newInstance(this.delegate.connectHandler((Handler)new Handler<io.vertx.core.net.NetSocket>(){

            public void handle(io.vertx.core.net.NetSocket event) {
                handler.handle((Object)NetSocket.newInstance(event));
            }
        }));
        return ret;
    }

    public NetServer connectHandler(Consumer<NetSocket> handler) {
        return this.__connectHandler(handler != null ? handler::accept : null);
    }

    private NetServer __listen(final Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen((Handler)new Handler<AsyncResult<io.vertx.core.net.NetServer>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<NetServer> listen() {
        return AsyncResultUni.toUni(handler -> this.__listen((Handler<AsyncResult<NetServer>>)handler));
    }

    public NetServer listenAndAwait() {
        return (NetServer)this.listen().await().indefinitely();
    }

    private NetServer __listen(int port, String host, final Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetServer>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<NetServer> listen(int port, String host) {
        return AsyncResultUni.toUni(handler -> this.__listen(port, host, (Handler<AsyncResult<NetServer>>)handler));
    }

    public NetServer listenAndAwait(int port, String host) {
        return (NetServer)this.listen(port, host).await().indefinitely();
    }

    private NetServer __listen(int port, final Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen(port, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetServer>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<NetServer> listen(int port) {
        return AsyncResultUni.toUni(handler -> this.__listen(port, (Handler<AsyncResult<NetServer>>)handler));
    }

    public NetServer listenAndAwait(int port) {
        return (NetServer)this.listen(port).await().indefinitely();
    }

    private NetServer __listen(SocketAddress localAddress, final Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen(localAddress.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.net.NetServer>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<NetServer> listen(SocketAddress localAddress) {
        return AsyncResultUni.toUni(handler -> this.__listen(localAddress, (Handler<AsyncResult<NetServer>>)handler));
    }

    public NetServer listenAndAwait(SocketAddress localAddress) {
        return (NetServer)this.listen(localAddress).await().indefinitely();
    }

    private void __close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public NetServer listenAndForget() {
        this.delegate.listen();
        return this;
    }

    public NetServer listenAndForget(int port, String host) {
        this.delegate.listen(port, host);
        return this;
    }

    public NetServer listenAndForget(int port) {
        this.delegate.listen(port);
        return this;
    }

    public NetServer listenAndForget(SocketAddress localAddress) {
        this.delegate.listen(localAddress.getDelegate());
        return this;
    }

    public void closeAndForget() {
        this.delegate.close();
    }

    public static NetServer newInstance(io.vertx.core.net.NetServer arg) {
        return arg != null ? new NetServer(arg) : null;
    }
}

