/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.JsonUtils;
import org.infinispan.protostream.impl.RawProtoStreamReaderImpl;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;

public final class ProtobufUtil {
    private static final int BUFFER_SIZE = 512;

    private ProtobufUtil() {
    }

    public static SerializationContext newSerializationContext() {
        return ProtobufUtil.newSerializationContext(Configuration.builder().build());
    }

    public static SerializationContext newSerializationContext(Configuration configuration) {
        SerializationContextImpl serializationContext = new SerializationContextImpl(configuration);
        try {
            serializationContext.registerProtoFiles(FileDescriptorSource.fromResources("org/infinispan/protostream/message-wrapping.proto"));
        }
        catch (IOException | DescriptorParserException e) {
            throw new RuntimeException("Failed to initialize serialization context", e);
        }
        serializationContext.registerMarshaller(new WrappedMessage.Marshaller());
        return serializationContext;
    }

    private static <A> void writeTo(ImmutableSerializationContext ctx, RawProtoStreamWriter out, A t) throws IOException {
        if (t == null) {
            throw new IllegalArgumentException("Object to marshall cannot be null");
        }
        BaseMarshallerDelegate<?> marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(t.getClass());
        marshallerDelegate.marshall(null, t, null, out);
        out.flush();
    }

    public static void writeTo(ImmutableSerializationContext ctx, OutputStream out, Object t) throws IOException {
        ProtobufUtil.writeTo(ctx, RawProtoStreamWriterImpl.newInstance(out), t);
    }

    public static byte[] toByteArray(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ProtobufUtil.writeTo(ctx, baos, t);
        return baos.toByteArray();
    }

    public static ByteBuffer toByteBuffer(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx(512);
        ProtobufUtil.writeTo(ctx, baos, t);
        return baos.getByteBuffer();
    }

    private static <A> A readFrom(ImmutableSerializationContext ctx, RawProtoStreamReader in, Class<A> clazz) throws IOException {
        BaseMarshallerDelegate<A> marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(clazz);
        return marshallerDelegate.unmarshall(null, null, in);
    }

    public static <A> A readFrom(ImmutableSerializationContext ctx, InputStream in, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(in), clazz);
    }

    public static <A> A fromByteArray(ImmutableSerializationContext ctx, byte[] bytes, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(bytes), clazz);
    }

    public static <A> A fromByteArray(ImmutableSerializationContext ctx, byte[] bytes, int offset, int length, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(bytes, offset, length), clazz);
    }

    public static <A> A fromByteBuffer(ImmutableSerializationContext ctx, ByteBuffer byteBuffer, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(byteBuffer), clazz);
    }

    public static <A> A fromWrappedByteArray(ImmutableSerializationContext ctx, byte[] bytes) throws IOException {
        return ProtobufUtil.fromWrappedByteArray(ctx, bytes, 0, bytes.length);
    }

    public static <A> A fromWrappedByteArray(ImmutableSerializationContext ctx, byte[] bytes, int offset, int length) throws IOException {
        return (A)WrappedMessage.readMessage(ctx, RawProtoStreamReaderImpl.newInstance(bytes, offset, length));
    }

    public static <A> A fromWrappedByteBuffer(ImmutableSerializationContext ctx, ByteBuffer byteBuffer) throws IOException {
        return (A)WrappedMessage.readMessage(ctx, RawProtoStreamReaderImpl.newInstance(byteBuffer));
    }

    public static <A> A fromWrappedStream(ImmutableSerializationContext ctx, InputStream in) throws IOException {
        return (A)WrappedMessage.readMessage(ctx, RawProtoStreamReaderImpl.newInstance(in));
    }

    public static byte[] toWrappedByteArray(ImmutableSerializationContext ctx, Object t) throws IOException {
        return ProtobufUtil.toWrappedByteArray(ctx, t, 512);
    }

    public static byte[] toWrappedByteArray(ImmutableSerializationContext ctx, Object t, int bufferSize) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bufferSize);
        WrappedMessage.writeMessage(ctx, RawProtoStreamWriterImpl.newInstance(baos), t);
        return baos.toByteArray();
    }

    public static ByteBuffer toWrappedByteBuffer(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx(512);
        WrappedMessage.writeMessage(ctx, RawProtoStreamWriterImpl.newInstance(baos), t);
        return baos.getByteBuffer();
    }

    public static void toWrappedStream(ImmutableSerializationContext ctx, OutputStream out, Object t) throws IOException {
        ProtobufUtil.toWrappedStream(ctx, out, t, 4096);
    }

    public static void toWrappedStream(ImmutableSerializationContext ctx, OutputStream out, Object t, int bufferSize) throws IOException {
        WrappedMessage.writeMessage(ctx, RawProtoStreamWriterImpl.newInstance(out, bufferSize), t);
    }

    public static String toCanonicalJSON(ImmutableSerializationContext ctx, byte[] bytes) throws IOException {
        return ProtobufUtil.toCanonicalJSON(ctx, bytes, true);
    }

    public static String toCanonicalJSON(ImmutableSerializationContext ctx, byte[] bytes, boolean prettyPrint) throws IOException {
        return JsonUtils.toCanonicalJSON(ctx, bytes, prettyPrint);
    }

    public static byte[] fromCanonicalJSON(ImmutableSerializationContext ctx, Reader reader) throws IOException {
        return JsonUtils.fromCanonicalJSON(ctx, reader);
    }
}

