/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.runtime;

import io.quarkus.runtime.metrics.MetricsFactory;
import io.smallrye.metrics.MetricRegistries;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;

public class SmallRyeMetricsFactory
implements MetricsFactory {
    public boolean metricsSystemSupported(String name) {
        return "smallrye-metrics".equals(name);
    }

    public MetricsFactory.MetricBuilder builder(String name, MetricsFactory.Type type) {
        return new SmallRyeMetricBuilder(name, type);
    }

    private static class SmallRyeTimeRecorder
    implements MetricsFactory.TimeRecorder {
        SimpleTimer timer;

        SmallRyeTimeRecorder(SimpleTimer timer) {
            this.timer = timer;
        }

        public void update(Duration duration) {
            this.timer.update(duration);
        }

        public void update(long duration, TimeUnit unit) {
            this.timer.update(Duration.ofNanos(unit.toNanos(duration)));
        }
    }

    private static class SmallRyeFunctionGauge<T, R extends Number>
    implements Gauge<R> {
        final T obj;
        final Function<T, R> f;

        SmallRyeFunctionGauge(T obj, Function<T, R> f) {
            this.obj = obj;
            this.f = f;
        }

        public R getValue() {
            return (R)((Number)this.f.apply(this.obj));
        }
    }

    private static class SmallRyeGauge
    implements Gauge<Long> {
        final Supplier<Number> f;

        SmallRyeGauge(Supplier<Number> f) {
            this.f = f;
        }

        public Long getValue() {
            return this.f.get().longValue();
        }
    }

    private static class SmallRyeFunctionCounter<T, R extends Number>
    implements Counter {
        final T obj;
        final Function<T, R> f;

        SmallRyeFunctionCounter(T obj, Function<T, R> f) {
            this.obj = obj;
            this.f = f;
        }

        public void inc() {
        }

        public void inc(long l) {
        }

        public long getCount() {
            return ((Number)this.f.apply(this.obj)).longValue();
        }
    }

    private static class SmallRyeCounter
    implements Counter {
        final Supplier<Number> f;

        SmallRyeCounter(Supplier<Number> f) {
            this.f = f;
        }

        public void inc() {
        }

        public void inc(long l) {
        }

        public long getCount() {
            return this.f.get().longValue();
        }
    }

    static class SmallRyeMetricBuilder
    implements MetricsFactory.MetricBuilder {
        final MetricRegistry registry;
        final MetadataBuilder builder;
        List<Tag> tags = new ArrayList<Tag>();

        SmallRyeMetricBuilder(String name, MetricsFactory.Type type) {
            switch (type) {
                case APPLICATION: {
                    this.registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.APPLICATION);
                    break;
                }
                case BASE: {
                    this.registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.BASE);
                    break;
                }
                default: {
                    this.registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);
                }
            }
            this.builder = Metadata.builder().withName(name);
        }

        public MetricsFactory.MetricBuilder unit(String unit) {
            this.builder.withUnit(unit);
            return this;
        }

        public MetricsFactory.MetricBuilder tag(String key, String value) {
            this.tags.add(new Tag(key, value));
            return this;
        }

        public MetricsFactory.MetricBuilder description(String description) {
            this.builder.withDescription(description);
            return this;
        }

        public void buildCounter(Supplier<Number> countFunction) {
            this.builder.withType(MetricType.COUNTER);
            this.registry.register(this.builder.build(), (Metric)new SmallRyeCounter(countFunction), this.tags.toArray(new Tag[0]));
        }

        public <T, R extends Number> void buildCounter(T obj, Function<T, R> countFunction) {
            this.builder.withType(MetricType.COUNTER);
            this.registry.register(this.builder.build(), new SmallRyeFunctionCounter<T, R>(obj, countFunction), this.tags.toArray(new Tag[0]));
        }

        public void buildGauge(Supplier<Number> gaugeFunction) {
            this.builder.withType(MetricType.GAUGE);
            this.registry.register(this.builder.build(), (Metric)new SmallRyeGauge(gaugeFunction), this.tags.toArray(new Tag[0]));
        }

        public <T, R extends Number> void buildGauge(T obj, Function<T, R> gaugeFunction) {
            this.builder.withType(MetricType.GAUGE);
            this.registry.register(this.builder.build(), new SmallRyeFunctionGauge<T, R>(obj, gaugeFunction), this.tags.toArray(new Tag[0]));
        }

        public MetricsFactory.TimeRecorder buildTimer() {
            this.builder.withType(MetricType.SIMPLE_TIMER);
            SimpleTimer timer = this.registry.simpleTimer(this.builder.build(), this.tags.toArray(new Tag[0]));
            return new SmallRyeTimeRecorder(timer);
        }

        public Runnable buildTimer(final Runnable f) {
            this.builder.withType(MetricType.SIMPLE_TIMER);
            final SimpleTimer timer = this.registry.simpleTimer(this.builder.build(), this.tags.toArray(new Tag[0]));
            return new Runnable(){

                @Override
                public void run() {
                    timer.time(f);
                }
            };
        }

        public <T> Callable<T> buildTimer(final Callable<T> f) {
            this.builder.withType(MetricType.SIMPLE_TIMER);
            final SimpleTimer timer = this.registry.simpleTimer(this.builder.build(), this.tags.toArray(new Tag[0]));
            return new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return timer.time(f);
                }
            };
        }

        public <T> Supplier<T> buildTimer(final Supplier<T> f) {
            this.builder.withType(MetricType.SIMPLE_TIMER);
            final SimpleTimer timer = this.registry.simpleTimer(this.builder.build(), this.tags.toArray(new Tag[0]));
            return new Supplier<T>(){

                @Override
                public T get() {
                    SimpleTimer.Context ctx = timer.time();
                    try {
                        Object t = f.get();
                        return t;
                    }
                    finally {
                        ctx.stop();
                    }
                }
            };
        }
    }
}

