/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cli;

import io.smallrye.config.ConfigValue;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.keycloak.configuration.Configuration;
import org.keycloak.configuration.PropertyMappers;
import org.keycloak.util.Environment;

public final class ShowConfigCommand {
    public static void run() {
        String configArgs = System.getProperty("kc.show.config");
        if (configArgs != null) {
            Map<String, Set<String>> properties = ShowConfigCommand.getPropertiesByGroup();
            HashSet uniqueNames = new HashSet();
            String profile = ShowConfigCommand.getProfile();
            System.out.printf("Current Profile: %s%n", profile == null ? "none" : profile);
            System.out.println("Runtime Configuration:");
            properties.get("kc").stream().sorted().filter(name -> {
                String canonicalFormat = PropertyMappers.canonicalFormat(name);
                if (!canonicalFormat.equals(name)) {
                    return uniqueNames.add(canonicalFormat);
                }
                return uniqueNames.add(name);
            }).forEachOrdered(ShowConfigCommand::printProperty);
            if (configArgs.equalsIgnoreCase("all")) {
                Set<String> profiles = properties.get("%");
                if (profiles != null) {
                    profiles.stream().sorted().collect(Collectors.groupingBy(s -> s.substring(1, s.indexOf(46)))).forEach((p, properties1) -> {
                        if (p.equals(profile)) {
                            System.out.printf("Profile \"%s\" Configuration (%s):%n", p, p.equals(profile) ? "current" : "");
                        } else {
                            System.out.printf("Profile \"%s\" Configuration:%n", p);
                        }
                        properties1.stream().sorted().forEachOrdered(ShowConfigCommand::printProperty);
                    });
                }
                System.out.println("Quarkus Configuration:");
                properties.get("quarkus").stream().sorted().forEachOrdered(ShowConfigCommand::printProperty);
            }
            if (!Boolean.parseBoolean(System.getProperty("kc.show.config.runtime", Boolean.FALSE.toString()))) {
                System.exit(0);
            }
        }
    }

    private static String getProfile() {
        String profile = Environment.getProfile();
        if (profile == null) {
            return Environment.getBuiltTimeProperty("quarkus.profile").orElse(null);
        }
        return profile;
    }

    private static Map<String, Set<String>> getPropertiesByGroup() {
        final Map<String, Set<String>> properties = StreamSupport.stream(Configuration.getPropertyNames().spliterator(), false).filter(ShowConfigCommand::filterByGroup).collect(Collectors.groupingBy(ShowConfigCommand::groupProperties, Collectors.toSet()));
        StreamSupport.stream(Configuration.getPropertyNames().spliterator(), false).filter(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                ConfigValue configValue = Configuration.getConfigValue(s);
                return configValue.getConfigSourceName().equals("PersistedConfigSource");
            }
        }).filter(property -> ShowConfigCommand.filterByGroup(property)).collect(Collectors.groupingBy(ShowConfigCommand::groupProperties, Collectors.toSet())).forEach(new BiConsumer<String, Set<String>>(){

            @Override
            public void accept(String group, Set<String> propertyNames) {
                properties.computeIfAbsent(group, name -> new HashSet()).addAll(propertyNames);
            }
        });
        return properties;
    }

    private static void printProperty(String property) {
        String canonicalFormat = PropertyMappers.canonicalFormat(property);
        ConfigValue configValue = Configuration.getConfigValue(canonicalFormat);
        if (configValue.getValue() == null) {
            configValue = Configuration.getConfigValue(property);
        }
        if (configValue.getValue() == null) {
            return;
        }
        System.out.printf("\t%s =  %s (%s)%n", configValue.getName(), PropertyMappers.formatValue(configValue.getName(), configValue.getValue()), configValue.getConfigSourceName());
    }

    private static String groupProperties(String property) {
        if (property.startsWith("%")) {
            return "%";
        }
        return property.substring(0, property.indexOf(46));
    }

    private static boolean filterByGroup(String property) {
        return property.startsWith("kc") || property.startsWith("quarkus") || property.startsWith("%");
    }
}

