/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.RemovedBean;
import io.quarkus.arc.impl.CollectionHelpers;
import io.quarkus.arc.impl.Qualifiers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;

public final class RemovedBeanImpl
implements RemovedBean {
    private final InjectableBean.Kind kind;
    private final String description;
    private final Set<Type> types;
    private final Set<Annotation> qualifiers;

    public RemovedBeanImpl(InjectableBean.Kind kind, String description, Set<Type> types, Set<Annotation> qualifiers) {
        this.kind = kind != null ? kind : InjectableBean.Kind.CLASS;
        this.description = description;
        this.types = CollectionHelpers.toImmutableSmallSet(types);
        this.qualifiers = qualifiers != null ? CollectionHelpers.toImmutableSmallSet(qualifiers) : Qualifiers.DEFAULT_QUALIFIERS;
    }

    @Override
    public InjectableBean.Kind getKind() {
        return this.kind;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.kind).append(" bean ").append(this.description).append(" [types=").append(this.types).append(", qualifiers=").append(this.qualifiers).append("]");
        return builder.toString();
    }
}

