/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RoleResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;

public class RoleByIdResource
extends RoleResource {
    protected static final Logger logger = Logger.getLogger(RoleByIdResource.class);
    private final RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    @Context
    private KeycloakSession session;

    public RoleByIdResource(RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        super(realm);
        this.realm = realm;
        this.auth = auth;
        this.adminEvent = adminEvent;
    }

    @Path(value="{role-id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RoleRepresentation getRole(@PathParam(value="role-id") String id) {
        RoleModel roleModel = this.getRoleModel(id);
        this.auth.roles().requireView(roleModel);
        return this.getRole(roleModel);
    }

    protected RoleModel getRoleModel(String id) {
        RoleModel roleModel = this.realm.getRoleById(id);
        if (roleModel == null) {
            throw new NotFoundException("Could not find role with id");
        }
        return roleModel;
    }

    @Path(value="{role-id}")
    @DELETE
    @NoCache
    public void deleteRole(@PathParam(value="role-id") String id) {
        if (this.realm.getDefaultRole() == null) {
            logger.warnf("Default role for realm with id '%s' doesn't exist.", (Object)this.realm.getId());
        } else if (this.realm.getDefaultRole().getId().equals(id)) {
            throw new ErrorResponseException(ErrorResponse.error(this.realm.getDefaultRole().getName() + " is default role of the realm and cannot be removed.", Response.Status.BAD_REQUEST));
        }
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireManage(role);
        this.deleteRole(role);
        if (role.isClientRole()) {
            this.adminEvent.resource(ResourceType.CLIENT_ROLE);
        } else {
            this.adminEvent.resource(ResourceType.REALM_ROLE);
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="{role-id}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRole(@PathParam(value="role-id") String id, RoleRepresentation rep) {
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireManage(role);
        this.updateRole(rep, role);
        if (role.isClientRole()) {
            this.adminEvent.resource(ResourceType.CLIENT_ROLE);
        } else {
            this.adminEvent.resource(ResourceType.REALM_ROLE);
        }
        this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
    }

    @Path(value="{role-id}/composites")
    @POST
    @Consumes(value={"application/json"})
    public void addComposites(@PathParam(value="role-id") String id, List<RoleRepresentation> roles) {
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireManage(role);
        this.addComposites(this.auth, this.adminEvent, (UriInfo)this.session.getContext().getUri(), roles, role);
    }

    @Path(value="{role-id}/composites")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<RoleRepresentation> getRoleComposites(@PathParam(value="role-id") String id) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("*** getRoleComposites: '" + id + "'"));
        }
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireView(role);
        return role.getCompositesStream().map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="{role-id}/composites/realm")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<RoleRepresentation> getRealmRoleComposites(@PathParam(value="role-id") String id) {
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireView(role);
        return this.getRealmRoleComposites(role);
    }

    @Path(value="{role-id}/composites/clients/{clientUuid}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<RoleRepresentation> getClientRoleComposites(@PathParam(value="role-id") String id, @PathParam(value="clientUuid") String clientUuid) {
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireView(role);
        ClientModel clientModel = this.realm.getClientById(clientUuid);
        if (clientModel == null) {
            throw new NotFoundException("Could not find client");
        }
        return this.getClientRoleComposites(clientModel, role);
    }

    @Path(value="{role-id}/composites")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteComposites(@PathParam(value="role-id") String id, List<RoleRepresentation> roles) {
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireManage(role);
        this.deleteComposites(this.adminEvent, (UriInfo)this.session.getContext().getUri(), roles, role);
    }

    @Path(value="{role-id}/management/permissions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public ManagementPermissionReference getManagementPermissions(@PathParam(value="role-id") String id) {
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireView(role);
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (!permissions.roles().isPermissionsEnabled(role)) {
            return new ManagementPermissionReference();
        }
        return RoleByIdResource.toMgmtRef(role, permissions);
    }

    public static ManagementPermissionReference toMgmtRef(RoleModel role, AdminPermissionManagement permissions) {
        ManagementPermissionReference ref = new ManagementPermissionReference();
        ref.setEnabled(true);
        ref.setResource(permissions.roles().resource(role).getId());
        ref.setScopePermissions(permissions.roles().getPermissions(role));
        return ref;
    }

    @Path(value="{role-id}/management/permissions")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NoCache
    public ManagementPermissionReference setManagementPermissionsEnabled(@PathParam(value="role-id") String id, ManagementPermissionReference ref) {
        RoleModel role = this.getRoleModel(id);
        this.auth.roles().requireManage(role);
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        permissions.roles().setPermissionsEnabled(role, ref.isEnabled());
        if (ref.isEnabled()) {
            return RoleByIdResource.toMgmtRef(role, permissions);
        }
        return new ManagementPermissionReference();
    }
}

