/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentCustomizerBuildItem;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthHandler;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.vertx.core.Handler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.keycloak.Config;
import org.keycloak.QuarkusKeycloakApplication;
import org.keycloak.authentication.AuthenticatorSpi;
import org.keycloak.authentication.authenticators.browser.DeployedScriptAuthenticatorFactory;
import org.keycloak.authorization.policy.provider.PolicySpi;
import org.keycloak.authorization.policy.provider.js.DeployedScriptPolicyFactory;
import org.keycloak.common.Profile;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.config.ConfigProviderFactory;
import org.keycloak.configuration.Configuration;
import org.keycloak.configuration.KeycloakConfigSourceProvider;
import org.keycloak.connections.jpa.DefaultJpaConnectionProviderFactory;
import org.keycloak.connections.jpa.updater.liquibase.LiquibaseJpaUpdaterProviderFactory;
import org.keycloak.connections.jpa.updater.liquibase.conn.DefaultLiquibaseConnectionProvider;
import org.keycloak.protocol.ProtocolMapperSpi;
import org.keycloak.protocol.oidc.mappers.DeployedScriptOIDCProtocolMapper;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.KeycloakDeploymentInfo;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.Spi;
import org.keycloak.provider.quarkus.QuarkusRequestFilter;
import org.keycloak.quarkus.KeycloakRecorder;
import org.keycloak.quarkus.deployment.BuildClassLoader;
import org.keycloak.representations.provider.ScriptProviderDescriptor;
import org.keycloak.representations.provider.ScriptProviderMetadata;
import org.keycloak.services.NotFoundHandler;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.health.KeycloakMetricsHandler;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.transaction.JBossJtaTransactionManagerLookup;
import org.keycloak.util.Environment;
import org.keycloak.util.JsonSerialization;

class KeycloakProcessor {
    private static final Logger logger = Logger.getLogger(KeycloakProcessor.class);
    private static final String JAR_FILE_SEPARATOR = "!/";
    private static final String DEFAULT_HEALTH_ENDPOINT = "/health";
    private static final Map<String, Function<ScriptProviderMetadata, ProviderFactory>> DEPLOYEABLE_SCRIPT_PROVIDERS = new HashMap<String, Function<ScriptProviderMetadata, ProviderFactory>>();
    private static final String KEYCLOAK_SCRIPTS_JSON_PATH = "META-INF/keycloak-scripts.json";

    KeycloakProcessor() {
    }

    private static ProviderFactory registerScriptAuthenticator(ScriptProviderMetadata metadata) {
        return new DeployedScriptAuthenticatorFactory(metadata);
    }

    private static ProviderFactory registerScriptPolicy(ScriptProviderMetadata metadata) {
        return new DeployedScriptPolicyFactory(metadata);
    }

    private static ProviderFactory registerScriptMapper(ScriptProviderMetadata metadata) {
        return new DeployedScriptOIDCProtocolMapper(metadata);
    }

    @BuildStep
    FeatureBuildItem getFeature() {
        return new FeatureBuildItem("keycloak");
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void configureHibernate(KeycloakRecorder recorder, HibernateOrmConfig config, List<PersistenceUnitDescriptorBuildItem> descriptors) {
        PersistenceUnitDescriptor unit = descriptors.get(0).asOutputPersistenceUnitDefinition(Collections.emptyList()).getActualHibernateDescriptor();
        unit.getProperties().setProperty("hibernate.dialect", config.defaultPersistenceUnit.dialect.dialect.orElse(null));
        unit.getProperties().setProperty("javax.persistence.transactionType", PersistenceUnitTransactionType.JTA.name());
        unit.getProperties().setProperty("hibernate.query.startup_check", Boolean.FALSE.toString());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void configureProviders(KeycloakRecorder recorder) {
        Profile.setInstance((Profile)recorder.createProfile());
        HashMap<Spi, Map> factories = new HashMap<Spi, Map>();
        HashMap<Class<? extends Provider>, String> defaultProviders = new HashMap<Class<? extends Provider>, String>();
        HashMap<String, ProviderFactory> preConfiguredProviders = new HashMap<String, ProviderFactory>();
        for (Map.Entry<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>> entry : this.loadFactories(preConfiguredProviders).entrySet()) {
            this.checkProviders(entry.getKey(), entry.getValue(), defaultProviders);
            for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> value : entry.getValue().entrySet()) {
                for (ProviderFactory factory : value.getValue().values()) {
                    factories.computeIfAbsent(entry.getKey(), key -> new HashMap()).computeIfAbsent(entry.getKey().getProviderClass(), aClass -> new HashMap()).put(factory.getId(), factory.getClass());
                }
            }
        }
        recorder.configSessionFactory(factories, defaultProviders, preConfiguredProviders, Environment.isRebuild());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void setBuildTimeProperties(KeycloakRecorder recorder) {
        Properties properties = new Properties();
        for (String name : Configuration.getPropertyNames()) {
            Optional value;
            if (this.isNotPersistentProperty(name) || !(value = Configuration.getOptionalValue((String)name)).isPresent()) continue;
            properties.put(name, value.get());
        }
        File file = KeycloakConfigSourceProvider.getPersistedConfigFile().toFile();
        if (file.exists()) {
            file.delete();
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            properties.store(fos, " Auto-generated, DO NOT change this file");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate persisted.properties file", e);
        }
        recorder.validateAndSetBuildTimeProperties(Environment.isRebuild(), Configuration.getRawValue((String)"kc.config.args"));
        recorder.showConfig();
    }

    private boolean isNotPersistentProperty(String name) {
        return !name.startsWith("kc") || "kc.home.dir".equals(name) || "kc.config.args".equals(name);
    }

    @BuildStep
    void index(BuildProducer<IndexDependencyBuildItem> indexDependencyBuildItemBuildProducer) {
        indexDependencyBuildItemBuildProducer.produce((BuildItem)new IndexDependencyBuildItem("org.liquibase", "liquibase-core"));
        indexDependencyBuildItemBuildProducer.produce((BuildItem)new IndexDependencyBuildItem("org.keycloak", "keycloak-services"));
    }

    @BuildStep
    void initializeFilter(BuildProducer<FilterBuildItem> filters) {
        filters.produce((BuildItem)new FilterBuildItem((Handler)new QuarkusRequestFilter(), 90));
    }

    @BuildStep
    void initializeMetrics(BuildProducer<RouteBuildItem> routes) {
        KeycloakMetricsHandler metricsHandler;
        SmallRyeHealthHandler healthHandler;
        if (this.isMetricsEnabled()) {
            healthHandler = new SmallRyeHealthHandler();
            metricsHandler = new KeycloakMetricsHandler();
        } else {
            healthHandler = new NotFoundHandler();
            metricsHandler = new NotFoundHandler();
        }
        routes.produce((BuildItem)new RouteBuildItem(DEFAULT_HEALTH_ENDPOINT, (Handler)healthHandler));
        routes.produce((BuildItem)new RouteBuildItem(DEFAULT_HEALTH_ENDPOINT.concat("/live"), (Handler)healthHandler));
        routes.produce((BuildItem)new RouteBuildItem(DEFAULT_HEALTH_ENDPOINT.concat("/ready"), (Handler)healthHandler));
        routes.produce((BuildItem)new RouteBuildItem("/metrics", (Handler)metricsHandler));
    }

    @BuildStep
    void configureResteasy(BuildProducer<ResteasyDeploymentCustomizerBuildItem> deploymentCustomizerProducer) {
        deploymentCustomizerProducer.produce((BuildItem)new ResteasyDeploymentCustomizerBuildItem((Consumer)new Consumer<ResteasyDeployment>(){

            @Override
            public void accept(ResteasyDeployment resteasyDeployment) {
                resteasyDeployment.setApplicationClass(QuarkusKeycloakApplication.class.getName());
                resteasyDeployment.setProperty("resteasy.disable.html.sanitizer", (Object)Boolean.TRUE);
            }
        }));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void configureDevMode(BuildProducer<HotDeploymentWatchedFileBuildItem> hotFiles) {
        hotFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("META-INF/keycloak.properties"));
    }

    private Map<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>> loadFactories(Map<String, ProviderFactory> preConfiguredProviders) {
        this.loadConfig();
        BuildClassLoader providerClassLoader = new BuildClassLoader();
        ProviderManager pm = new ProviderManager(KeycloakDeploymentInfo.create().services(), (ClassLoader)providerClassLoader, new String[0]);
        HashMap<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>> factories = new HashMap<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>>();
        for (Spi spi : pm.loadSpis()) {
            HashMap<Class, Map> providers = new HashMap<Class, Map>();
            ArrayList<ProviderFactory> loadedFactories = new ArrayList<ProviderFactory>(pm.load(spi));
            Map<String, ProviderFactory> deployedScriptProviders = this.loadDeployedScriptProviders(providerClassLoader, spi);
            loadedFactories.addAll(deployedScriptProviders.values());
            preConfiguredProviders.putAll(deployedScriptProviders);
            for (ProviderFactory factory : loadedFactories) {
                if (Arrays.asList(JBossJtaTransactionManagerLookup.class, DefaultJpaConnectionProviderFactory.class, DefaultLiquibaseConnectionProvider.class, LiquibaseJpaUpdaterProviderFactory.class).contains(factory.getClass())) continue;
                Config.Scope scope = Config.scope((String[])new String[]{spi.getName(), factory.getId()});
                if (this.isEnabled(factory, scope)) {
                    if (spi.isInternal() && !this.isInternal(factory)) {
                        ServicesLogger.LOGGER.spiMayChange(factory.getId(), factory.getClass().getName(), spi.getName());
                    }
                    providers.computeIfAbsent(spi.getProviderClass(), aClass -> new HashMap()).put(factory.getId(), factory);
                    continue;
                }
                logger.debugv("SPI {0} provider {1} disabled", (Object)spi.getName(), (Object)factory.getId());
            }
            factories.put(spi, providers);
        }
        return factories;
    }

    private Map<String, ProviderFactory> loadDeployedScriptProviders(BuildClassLoader providerClassLoader, Spi spi) {
        HashMap<String, ProviderFactory> providers = new HashMap<String, ProviderFactory>();
        if (this.supportsDeployeableScripts(spi)) {
            try {
                Enumeration<URL> urls = providerClassLoader.getResources(KEYCLOAK_SCRIPTS_JSON_PATH);
                while (urls.hasMoreElements()) {
                    ScriptProviderDescriptor descriptor;
                    URL url = urls.nextElement();
                    int fileSeparator = url.getFile().indexOf(JAR_FILE_SEPARATOR);
                    if (fileSeparator == -1) continue;
                    JarFile jarFile = new JarFile(url.getFile().substring("file:".length(), fileSeparator));
                    JarEntry descriptorEntry = jarFile.getJarEntry(KEYCLOAK_SCRIPTS_JSON_PATH);
                    Throwable throwable = null;
                    try (InputStream is = jarFile.getInputStream(descriptorEntry);){
                        descriptor = (ScriptProviderDescriptor)JsonSerialization.readValue((InputStream)is, ScriptProviderDescriptor.class);
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    for (Map.Entry<String, List<ScriptProviderMetadata>> entry : descriptor.getProviders().entrySet()) {
                        if (!this.isScriptForSpi(spi, (String)entry.getKey())) continue;
                        for (ScriptProviderMetadata metadata : (List)entry.getValue()) {
                            ProviderFactory provider = this.createDeployableScriptProvider(jarFile, entry, metadata);
                            providers.put(metadata.getId(), provider);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to discover script providers", e);
            }
        }
        return providers;
    }

    private ProviderFactory createDeployableScriptProvider(JarFile jarFile, Map.Entry<String, List<ScriptProviderMetadata>> entry, ScriptProviderMetadata metadata) throws IOException {
        String fileName = metadata.getFileName();
        if (fileName == null) {
            throw new RuntimeException("You must provide the script file name");
        }
        JarEntry scriptFile = jarFile.getJarEntry(fileName);
        try (InputStream in = jarFile.getInputStream(scriptFile);){
            metadata.setCode(StreamUtil.readString((InputStream)in, (Charset)StandardCharsets.UTF_8));
        }
        metadata.setId("script" + "-" + fileName);
        String name = metadata.getName();
        if (name == null) {
            name = fileName;
        }
        metadata.setName(name);
        return DEPLOYEABLE_SCRIPT_PROVIDERS.get(entry.getKey()).apply(metadata);
    }

    private boolean isScriptForSpi(Spi spi, String type) {
        if (spi instanceof ProtocolMapperSpi && "mappers".equals(type)) {
            return true;
        }
        if (spi instanceof PolicySpi && "policies".equals(type)) {
            return true;
        }
        return spi instanceof AuthenticatorSpi && "authenticators".equals(type);
    }

    private boolean supportsDeployeableScripts(Spi spi) {
        return spi instanceof ProtocolMapperSpi || spi instanceof PolicySpi || spi instanceof AuthenticatorSpi;
    }

    private boolean isEnabled(ProviderFactory factory, Config.Scope scope) {
        if (!scope.getBoolean("enabled", Boolean.valueOf(true)).booleanValue()) {
            return false;
        }
        if (factory instanceof EnvironmentDependentProviderFactory) {
            return ((EnvironmentDependentProviderFactory)factory).isSupported();
        }
        return true;
    }

    private boolean isInternal(ProviderFactory<?> factory) {
        String packageName = factory.getClass().getPackage().getName();
        return packageName.startsWith("org.keycloak") && !packageName.startsWith("org.keycloak.examples");
    }

    private void checkProviders(Spi spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>> factoriesMap, Map<Class<? extends Provider>, String> defaultProviders) {
        String defaultProvider = Config.getProvider((String)spi.getName());
        if (defaultProvider != null) {
            Map<String, ProviderFactory> map = factoriesMap.get(spi.getProviderClass());
            if (map == null || map.get(defaultProvider) == null) {
                throw new RuntimeException("Failed to find provider " + defaultProvider + " for " + spi.getName());
            }
        } else {
            Optional<ProviderFactory> highestPriority;
            Map<String, ProviderFactory> factories = factoriesMap.get(spi.getProviderClass());
            if (factories != null && factories.size() == 1) {
                defaultProvider = factories.values().iterator().next().getId();
            }
            if (factories != null && defaultProvider == null && (highestPriority = factories.values().stream().max(Comparator.comparing(ProviderFactory::order))).isPresent() && highestPriority.get().order() > 0) {
                defaultProvider = highestPriority.get().getId();
            }
            if (defaultProvider == null && (factories == null || factories.containsKey("default"))) {
                defaultProvider = "default";
            }
        }
        if (defaultProvider != null) {
            defaultProviders.put(spi.getProviderClass(), defaultProvider);
        } else {
            logger.debugv("No default provider for {0}", (Object)spi.getName());
        }
    }

    protected void loadConfig() {
        ServiceLoader<ConfigProviderFactory> loader = ServiceLoader.load(ConfigProviderFactory.class, KeycloakApplication.class.getClassLoader());
        try {
            ConfigProviderFactory factory = loader.iterator().next();
            logger.debugv("ConfigProvider: {0}", (Object)factory.getClass().getName());
            Config.init((Config.ConfigProvider)((Config.ConfigProvider)factory.create().orElseThrow(() -> new RuntimeException("Failed to load Keycloak configuration"))));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("No valid ConfigProvider found");
        }
    }

    private boolean isMetricsEnabled() {
        return Configuration.getOptionalBooleanValue((String)"kc.".concat("metrics.enabled")).orElse(false);
    }

    static {
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("authenticators", KeycloakProcessor::registerScriptAuthenticator);
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("policies", KeycloakProcessor::registerScriptPolicy);
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("mappers", KeycloakProcessor::registerScriptMapper);
    }
}

