/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class AuthenticationRequest
implements Serializable {
    private final byte[] credentialId;
    private final byte[] userHandle;
    private final byte[] authenticatorData;
    private final byte[] clientDataJSON;
    private final String clientExtensionsJSON;
    private final byte[] signature;

    public AuthenticationRequest(byte[] credentialId, byte[] userHandle, byte[] authenticatorData, byte[] clientDataJSON, String clientExtensionsJSON, byte[] signature) {
        this.credentialId = ArrayUtil.clone((byte[])credentialId);
        this.userHandle = ArrayUtil.clone((byte[])userHandle);
        this.authenticatorData = ArrayUtil.clone((byte[])authenticatorData);
        this.clientDataJSON = ArrayUtil.clone((byte[])clientDataJSON);
        this.clientExtensionsJSON = clientExtensionsJSON;
        this.signature = ArrayUtil.clone((byte[])signature);
    }

    public AuthenticationRequest(byte[] credentialId, byte[] authenticatorData, byte[] clientDataJSON, String clientExtensionsJSON, byte[] signature) {
        this(credentialId, null, authenticatorData, clientDataJSON, clientExtensionsJSON, signature);
    }

    public AuthenticationRequest(byte[] credentialId, byte[] userHandle, byte[] authenticatorData, byte[] clientDataJSON, byte[] signature) {
        this(credentialId, userHandle, authenticatorData, clientDataJSON, null, signature);
    }

    public AuthenticationRequest(byte[] credentialId, byte[] authenticatorData, byte[] clientDataJSON, byte[] signature) {
        this(credentialId, null, authenticatorData, clientDataJSON, signature);
    }

    public byte[] getCredentialId() {
        return ArrayUtil.clone((byte[])this.credentialId);
    }

    public byte[] getUserHandle() {
        return ArrayUtil.clone((byte[])this.userHandle);
    }

    public byte[] getAuthenticatorData() {
        return ArrayUtil.clone((byte[])this.authenticatorData);
    }

    public byte[] getClientDataJSON() {
        return ArrayUtil.clone((byte[])this.clientDataJSON);
    }

    public String getClientExtensionsJSON() {
        return this.clientExtensionsJSON;
    }

    public byte[] getSignature() {
        return ArrayUtil.clone((byte[])this.signature);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationRequest that = (AuthenticationRequest)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Arrays.equals(this.userHandle, that.userHandle) && Arrays.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.clientDataJSON, that.clientDataJSON) && Objects.equals(this.clientExtensionsJSON, that.clientExtensionsJSON) && Arrays.equals(this.signature, that.signature);
    }

    public int hashCode() {
        int result = Objects.hash(this.clientExtensionsJSON);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        result = 31 * result + Arrays.hashCode(this.userHandle);
        result = 31 * result + Arrays.hashCode(this.authenticatorData);
        result = 31 * result + Arrays.hashCode(this.clientDataJSON);
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }
}

