/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CapabilityErrors {
    private final Map<String, List<String>> conflicts = new HashMap<String, List<String>>();

    public void addConflict(String capability, String provider) {
        this.conflicts.computeIfAbsent(capability, k -> new ArrayList()).add(provider);
    }

    public boolean isEmpty() {
        return this.conflicts.isEmpty();
    }

    public String report() {
        StringWriter sw = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(sw);){
            writer.write("Please make sure there is only one provider of the following capabilities:");
            ArrayList<String> capabilities = new ArrayList<String>(this.conflicts.size());
            capabilities.addAll(this.conflicts.keySet());
            Collections.sort(capabilities);
            for (String capability : capabilities) {
                writer.newLine();
                writer.append("capability ").append(capability).append(" is provided by:");
                List<String> providers = this.conflicts.get(capability);
                Collections.sort(providers);
                for (String provider : providers) {
                    writer.newLine();
                    writer.append("  - ").append(provider);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate the capability conflicts report out of " + this.conflicts, e);
        }
        return sw.getBuffer().toString();
    }
}

