/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.vault;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.vault.VaultKVSecretEngine;
import io.quarkus.vault.runtime.VaultConfigHolder;
import java.lang.annotation.Annotation;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.quarkus.runtime.vault.QuarkusVaultProvider;
import org.keycloak.vault.AbstractVaultProviderFactory;
import org.keycloak.vault.VaultProvider;

public class QuarkusVaultProviderFactory
extends AbstractVaultProviderFactory
implements EnvironmentDependentProviderFactory {
    private String[] kvPaths;
    private VaultKVSecretEngine secretEngine;

    public VaultProvider create(KeycloakSession session) {
        return new QuarkusVaultProvider(this.secretEngine, this.kvPaths, this.getRealmName(session), this.keyResolvers);
    }

    public void init(Config.Scope config) {
        super.init(config);
        this.kvPaths = config.getArray("paths");
    }

    public void postInit(KeycloakSessionFactory factory) {
        InstanceHandle configInstance;
        InstanceHandle engineInstance = Arc.container().instance(VaultKVSecretEngine.class, new Annotation[0]);
        if (engineInstance.isAvailable()) {
            this.secretEngine = (VaultKVSecretEngine)engineInstance.get();
        }
        if (!(configInstance = Arc.container().instance(VaultConfigHolder.class, new Annotation[0])).isAvailable() || ((VaultConfigHolder)configInstance.get()).getVaultBootstrapConfig() == null) {
            throw new RuntimeException("No configuration defined for hashicorp provider.");
        }
    }

    public void close() {
    }

    public String getId() {
        return "hashicorp";
    }

    public int order() {
        return 10;
    }

    public boolean isSupported(Config.Scope config) {
        return !config.getPropertyNames().isEmpty();
    }

    public boolean isSupported() {
        return false;
    }
}

