/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.web;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Resteasy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.services.resources.KeycloakApplication;

public class QuarkusRequestFilter
implements Handler<RoutingContext> {
    private static final Handler<AsyncResult<Object>> EMPTY_RESULT = result -> {};

    public void handle(RoutingContext context) {
        context.vertx().executeBlocking(this.createBlockingHandler(context), false, EMPTY_RESULT);
    }

    private Handler<Promise<Object>> createBlockingHandler(RoutingContext context) {
        return promise -> {
            KeycloakSessionFactory sessionFactory = KeycloakApplication.getSessionFactory();
            KeycloakSession session = sessionFactory.create();
            this.configureContextualData(context, this.createClientConnection(context.request()), session);
            this.configureEndHandler(context, (Promise<Object>)promise, session);
            KeycloakTransactionManager tx = session.getTransactionManager();
            try {
                tx.begin();
                context.next();
                promise.complete();
            }
            catch (Throwable cause) {
                promise.fail(cause);
                throw new RuntimeException(cause);
            }
            finally {
                if (!context.response().headWritten()) {
                    this.close(session);
                }
            }
        };
    }

    private void configureEndHandler(RoutingContext context, Promise<Object> promise, KeycloakSession session) {
        context.addHeadersEndHandler(event -> {
            try {
                this.close(session);
            }
            catch (Throwable cause) {
                promise.fail(cause);
            }
        });
    }

    private void configureContextualData(RoutingContext context, ClientConnection connection, KeycloakSession session) {
        Resteasy.pushContext(ClientConnection.class, (Object)connection);
        Resteasy.pushContext(KeycloakSession.class, (Object)session);
        context.put(KeycloakSession.class.getName(), (Object)session);
        context.put(ClientConnection.class.getName(), (Object)connection);
    }

    protected void close(KeycloakSession session) {
        KeycloakTransactionManager tx = session.getTransactionManager();
        if (tx.isActive()) {
            if (tx.getRollbackOnly()) {
                tx.rollback();
            } else {
                tx.commit();
            }
        }
        session.close();
    }

    private ClientConnection createClientConnection(final HttpServerRequest request) {
        return new ClientConnection(){

            public String getRemoteAddr() {
                return request.remoteAddress().host();
            }

            public String getRemoteHost() {
                return request.remoteAddress().host();
            }

            public int getRemotePort() {
                return request.remoteAddress().port();
            }

            public String getLocalAddr() {
                return request.localAddress().host();
            }

            public int getLocalPort() {
                return request.localAddress().port();
            }
        };
    }
}

