/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.management.ObjectName;
import org.eclipse.microprofile.metrics.MetricID;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metrics.impl.CacheManagerMetricsRegistration;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.SecurityActions;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.ServerStateManager;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.utils.ManageableThreadPoolExecutorService;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.spi.TaskEngine;

public abstract class AbstractProtocolServer<C extends ProtocolServerConfiguration>
implements ProtocolServer<C> {
    private static final Log log = (Log)LogFactory.getLog(AbstractProtocolServer.class, Log.class);
    private final String protocolName;
    protected NettyTransport transport;
    protected EmbeddedCacheManager cacheManager;
    protected C configuration;
    protected ServerManagement server;
    private ServerStateManager serverStateManager;
    private ObjectName transportObjName;
    private CacheManagerJmxRegistration jmxRegistration;
    private ExecutorService executor;
    private ManageableThreadPoolExecutorService manageableThreadPoolExecutorService;
    private ObjectName executorObjName;
    private CacheManagerMetricsRegistration metricsRegistration;
    private Set<MetricID> metricIds;
    private ProtocolServer<?> enclosingProtocolServer;
    protected boolean adminEndpoint = false;

    protected AbstractProtocolServer(String protocolName) {
        this.protocolName = protocolName;
    }

    @Override
    public String getName() {
        return this.protocolName;
    }

    protected void startInternal() {
        this.registerAdminOperationsHandler();
        this.startCaches();
        if (((ProtocolServerConfiguration)((Object)this.configuration)).startTransport()) {
            this.startTransport();
        }
    }

    private void registerAdminOperationsHandler() {
        if (((ProtocolServerConfiguration)((Object)this.configuration)).adminOperationsHandler() != null) {
            TaskManager taskManager = (TaskManager)SecurityActions.getGlobalComponentRegistry(this.cacheManager).getComponent(TaskManager.class);
            if (taskManager != null) {
                taskManager.registerTaskEngine((TaskEngine)((ProtocolServerConfiguration)((Object)this.configuration)).adminOperationsHandler());
            } else {
                throw log.cannotRegisterAdminOperationsHandler();
            }
        }
    }

    @Override
    public void setServerManagement(ServerManagement server, boolean adminEndpoint) {
        this.server = server;
        this.adminEndpoint = adminEndpoint;
    }

    protected boolean isCacheIgnored(String cache) {
        return this.serverStateManager != null && this.serverStateManager.isCacheIgnored(cache);
    }

    public ServerStateManager getServerStateManager() {
        return this.serverStateManager;
    }

    @Override
    public void start(C configuration, EmbeddedCacheManager cacheManager) {
        if (log.isDebugEnabled()) {
            log.debugf("Starting server with configuration: %s", configuration);
        }
        this.configuration = configuration;
        this.cacheManager = cacheManager;
        BasicComponentRegistry bcr = (BasicComponentRegistry)SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(BasicComponentRegistry.class.getName());
        ComponentRef stateManagerComponentRef = bcr.getComponent(ServerStateManager.class);
        if (stateManagerComponentRef != null) {
            this.serverStateManager = (ServerStateManager)stateManagerComponentRef.running();
        }
        bcr.replaceComponent(this.getQualifiedName(), (Object)this, false);
        this.executor = (ExecutorService)bcr.getComponent("org.infinispan.executors.blocking", ExecutorService.class).running();
        this.manageableThreadPoolExecutorService = new ManageableThreadPoolExecutorService(this.executor);
        try {
            this.startInternal();
        }
        catch (RuntimeException t) {
            this.stop();
            throw t;
        }
    }

    protected void startTransport() {
        log.debugf("Starting Netty transport for %s on %s:%s", ((ProtocolServerConfiguration)((Object)this.configuration)).name(), ((ProtocolServerConfiguration)((Object)this.configuration)).host(), ((ProtocolServerConfiguration)((Object)this.configuration)).port());
        InetSocketAddress address = new InetSocketAddress(((ProtocolServerConfiguration)((Object)this.configuration)).host(), ((ProtocolServerConfiguration)((Object)this.configuration)).port());
        this.transport = new NettyTransport(address, (ProtocolServerConfiguration)((Object)this.configuration), this.getQualifiedName(), this.cacheManager);
        this.transport.initializeHandler(this.getInitializer());
        this.registerServerMBeans();
        try {
            this.transport.start();
        }
        catch (Throwable re) {
            try {
                this.unregisterServerMBeans();
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
            throw re;
        }
        this.registerMetrics();
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    protected void registerServerMBeans() {
        if (this.cacheManager != null && SecurityActions.getCacheManagerConfiguration(this.cacheManager).jmx().enabled()) {
            this.jmxRegistration = (CacheManagerJmxRegistration)SecurityActions.getGlobalComponentRegistry(this.cacheManager).getComponent(CacheManagerJmxRegistration.class);
            String groupName = String.format("type=Server,name=%s-%d", this.getQualifiedName(), ((ProtocolServerConfiguration)((Object)this.configuration)).port());
            try {
                this.transportObjName = this.jmxRegistration.registerExternalMBean((Object)this.transport, groupName);
                if (this.manageableThreadPoolExecutorService != null) {
                    this.executorObjName = this.jmxRegistration.registerExternalMBean((Object)this.manageableThreadPoolExecutorService, groupName);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void unregisterServerMBeans() throws Exception {
        if (this.transportObjName != null) {
            this.jmxRegistration.unregisterMBean(this.transportObjName);
        }
        if (this.executorObjName != null) {
            this.jmxRegistration.unregisterMBean(this.executorObjName);
        }
    }

    protected void registerMetrics() {
        this.metricsRegistration = (CacheManagerMetricsRegistration)SecurityActions.getGlobalComponentRegistry(this.cacheManager).getComponent(CacheManagerMetricsRegistration.class);
        if (this.metricsRegistration.metricsEnabled()) {
            String protocol = "server_" + this.getQualifiedName() + '_' + ((ProtocolServerConfiguration)((Object)this.configuration)).port();
            this.metricIds = Collections.synchronizedSet(this.metricsRegistration.registerExternalMetrics((Object)this.transport, protocol));
            this.metricIds.addAll(this.metricsRegistration.registerExternalMetrics((Object)this.manageableThreadPoolExecutorService, protocol));
        }
    }

    protected void unregisterMetrics() {
        if (this.metricIds != null) {
            this.metricsRegistration.unregisterMetrics(this.metricIds);
            this.metricIds = null;
        }
    }

    public final String getQualifiedName() {
        if (this.configuration == null) {
            return this.protocolName;
        }
        return this.protocolName + (((ProtocolServerConfiguration)((Object)this.configuration)).name().length() > 0 ? "-" : "") + ((ProtocolServerConfiguration)((Object)this.configuration)).name();
    }

    @Override
    public void stop() {
        boolean isDebug = log.isDebugEnabled();
        if (isDebug && this.configuration != null) {
            log.debugf("Stopping server %s listening at %s:%d", this.getQualifiedName(), ((ProtocolServerConfiguration)((Object)this.configuration)).host(), ((ProtocolServerConfiguration)((Object)this.configuration)).port());
        }
        if (this.transport != null) {
            this.transport.stop();
        }
        try {
            this.unregisterServerMBeans();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        this.unregisterMetrics();
        if (isDebug) {
            log.debugf("Server %s stopped", this.getQualifiedName());
        }
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getHost() {
        return ((ProtocolServerConfiguration)((Object)this.configuration)).host();
    }

    public Integer getPort() {
        if (this.transport != null) {
            return this.transport.getPort();
        }
        return ((ProtocolServerConfiguration)((Object)this.configuration)).port();
    }

    @Override
    public C getConfiguration() {
        return this.configuration;
    }

    protected void startCaches() {
        String name = this.defaultCacheName();
        if (name != null) {
            log.debugf("Starting default cache: %s", ((ProtocolServerConfiguration)((Object)this.configuration)).defaultCacheName());
            this.cacheManager.getCache(name);
        } else {
            log.debugf("No default cache to start", new Object[0]);
        }
    }

    public String defaultCacheName() {
        if (((ProtocolServerConfiguration)((Object)this.configuration)).defaultCacheName() != null) {
            return ((ProtocolServerConfiguration)((Object)this.configuration)).defaultCacheName();
        }
        return SecurityActions.getCacheManagerConfiguration(this.cacheManager).defaultCacheName().orElse(null);
    }

    public boolean isTransportEnabled() {
        return this.transport != null;
    }

    @Override
    public NettyTransport getTransport() {
        return this.transport;
    }

    @Override
    public void setEnclosingProtocolServer(ProtocolServer<?> enclosingProtocolServer) {
        this.enclosingProtocolServer = enclosingProtocolServer;
    }

    @Override
    public ProtocolServer<?> getEnclosingProtocolServer() {
        return this.enclosingProtocolServer;
    }
}

