/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import io.quarkus.bootstrap.runner.QuarkusEntryPoint;
import io.quarkus.bootstrap.runner.RunnerClassLoader;
import io.quarkus.runtime.configuration.ProfileManager;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.cli.command.HelpAllMixin;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import picocli.CommandLine;

@CommandLine.Command(name="build", header={"Creates a new and optimized server image."}, description={"%nCreates a new and optimized server image based on the configuration options passed to this command. Once created, the configuration will be persisted and read during startup without having to pass them over again.", "", "Some configuration options require this command to be executed in order to actually change a configuration. For instance", "", "- Change database vendor%n- Enable/disable features%n- Enable/Disable providers or set a default", "", "Consider running this command before running the server in production for an optimal runtime."}, footerHeading="Examples:", footer={"  Optimize the server based on a profile configuration:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} --profile=prod ${COMMAND-NAME}%n%n  Change database settings:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --db=postgres [--db-url][--db-username][--db-password]%n%n  Enable a feature:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --features-<feature_name>=[enabled|disabled]%n%n  Or alternatively, enable all tech preview features:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --features=preview%n%n  Enable metrics:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --metrics-enabled=true%n%n  Change the relative path:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --http-relative-path=/auth%n%nYou can also use the \"--auto-build\" option when starting the server to avoid running this command every time you change a configuration:%n%n    $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} start --auto-build <OPTIONS>%n%nBy doing that you have an additional overhead when the server is starting.%n%nUse '${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --help-all' to list all available options, including the start options."})
public final class Build
extends AbstractCommand
implements Runnable {
    public static final String NAME = "build";
    @CommandLine.Mixin
    HelpAllMixin helpAllMixin;

    @Override
    public void run() {
        this.exitWithErrorIfDevProfileIsSetAndNotStartDev();
        System.setProperty("quarkus.launch.rebuild", "true");
        Picocli.println(this.spec.commandLine(), "Updating the configuration and installing your custom providers, if any. Please wait.");
        try {
            this.beforeReaugmentationOnWindows();
            QuarkusEntryPoint.main((String[])new String[0]);
            if (!Environment.isDevMode()) {
                Picocli.println(this.spec.commandLine(), "Server configuration updated and persisted. Run the following command to review the configuration:\n");
                Picocli.println(this.spec.commandLine(), "\t" + Environment.getCommand() + " show-config\n");
            }
        }
        catch (Throwable throwable) {
            this.executionError(this.spec.commandLine(), "Failed to update server configuration.", throwable);
        }
        finally {
            this.cleanTempResources();
        }
    }

    private void exitWithErrorIfDevProfileIsSetAndNotStartDev() {
        if (Environment.isDevProfile() && !ConfigArgsConfigSource.getAllCliArgs().contains("start-dev")) {
            this.executionError(this.spec.commandLine(), Messages.devProfileNotAllowedError(NAME));
        }
    }

    private void beforeReaugmentationOnWindows() {
        ClassLoader classLoader;
        if (Environment.isWindows() && (classLoader = Thread.currentThread().getContextClassLoader()) instanceof RunnerClassLoader) {
            ((RunnerClassLoader)classLoader).resetInternalCaches();
        }
    }

    private void cleanTempResources() {
        if (!ProfileManager.getLaunchMode().isDevOrTest()) {
            Environment.getHomePath().resolve("quarkus-artifact.properties").toFile().delete();
        }
    }
}

