/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.deployment.QuarkusClassWriter;
import java.util.function.BiFunction;
import net.bytebuddy.ClassFileVersion;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.bytecode.internal.bytebuddy.BytecodeProviderImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class HibernateEntityEnhancer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private static final BytecodeProvider PROVIDER = new BytecodeProviderImpl(ClassFileVersion.JAVA_V8);

    @Override
    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new HibernateEnhancingClassVisitor(className, outputClassVisitor);
    }

    public byte[] enhance(String className, byte[] bytes) {
        DefaultEnhancementContext enhancementContext = new DefaultEnhancementContext(){

            public ClassLoader getLoadingClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        Enhancer enhancer = PROVIDER.getEnhancer((EnhancementContext)enhancementContext);
        return enhancer.enhance(className, bytes);
    }

    private static class HibernateEnhancingClassVisitor
    extends ClassVisitor {
        private final String className;
        private final ClassVisitor outputClassVisitor;
        private final Enhancer enhancer;

        public HibernateEnhancingClassVisitor(String className, ClassVisitor outputClassVisitor) {
            super(589824, (ClassVisitor)new QuarkusClassWriter(3));
            this.className = className;
            this.outputClassVisitor = outputClassVisitor;
            DefaultEnhancementContext enhancementContext = new DefaultEnhancementContext(){

                public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
                    return false;
                }

                public ClassLoader getLoadingClassLoader() {
                    return Thread.currentThread().getContextClassLoader();
                }
            };
            this.enhancer = PROVIDER.getEnhancer((EnhancementContext)enhancementContext);
        }

        public void visitEnd() {
            super.visitEnd();
            ClassWriter writer = (ClassWriter)this.cv;
            byte[] inputBytes = writer.toByteArray();
            byte[] transformedBytes = this.hibernateEnhancement(this.className, inputBytes);
            ClassReader cr = new ClassReader(transformedBytes);
            cr.accept(this.outputClassVisitor, 0);
        }

        private byte[] hibernateEnhancement(String className, byte[] originalBytes) {
            byte[] enhanced = this.enhancer.enhance(className, originalBytes);
            return enhanced == null ? originalBytes : enhanced;
        }
    }
}

