/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.cli.command.Main;
import picocli.CommandLine;

public abstract class AbstractExportImportCommand
extends AbstractCommand
implements Runnable {
    private final String action;
    @CommandLine.Option(names={"--dir"}, arity="1", description={"Set the path to a directory where files will be created with the exported data."}, paramLabel="<path>")
    String toDir;
    @CommandLine.Option(names={"--file"}, arity="1", description={"Set the path to a file that will be created with the exported data."}, paramLabel="<path>")
    String toFile;
    @CommandLine.Option(names={"--realm"}, arity="1", description={"Set the name of the realm to export"}, paramLabel="<realm>")
    String realm;

    protected AbstractExportImportCommand(String action) {
        this.action = action;
    }

    @Override
    public void run() {
        this.doBeforeRun();
        System.setProperty("keycloak.migration.action", this.action);
        if (this.toDir != null) {
            System.setProperty("keycloak.migration.provider", "dir");
            System.setProperty("keycloak.migration.dir", this.toDir);
        } else if (this.toFile != null) {
            System.setProperty("keycloak.migration.provider", "singleFile");
            System.setProperty("keycloak.migration.file", this.toFile);
        } else {
            this.executionError(this.spec.commandLine(), "Must specify either --dir or --file options.");
        }
        if (this.realm != null) {
            System.setProperty("keycloak.migration.realmName", this.realm);
        }
        Environment.setProfile("import_export");
        new CommandLine((Object)new Main()).execute(new String[]{"start"});
    }

    protected void doBeforeRun() {
    }
}

