/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.entries;

import net.jcip.annotations.Immutable;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.impl.Utils;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@Immutable
@ProtoTypeId(value=125)
public class CounterValue {
    private static final CounterValue ZERO = new CounterValue(0L, CounterState.VALID);
    private final long value;
    private final CounterState state;

    @ProtoFactory
    CounterValue(long value, CounterState state) {
        this.value = value;
        this.state = state;
    }

    public static CounterValue newCounterValue(long value) {
        return value == 0L ? ZERO : new CounterValue(value, CounterState.VALID);
    }

    public static CounterValue newCounterValue(long value, long lowerBound, long upperBound) {
        return new CounterValue(value, Utils.calculateState(value, lowerBound, upperBound));
    }

    public static CounterValue newCounterValue(long value, CounterState state) {
        return new CounterValue(value, state);
    }

    public static CounterValue newCounterValue(CounterConfiguration configuration) {
        return configuration.type() == CounterType.BOUNDED_STRONG ? CounterValue.newCounterValue(configuration.initialValue(), configuration.lowerBound(), configuration.upperBound()) : CounterValue.newCounterValue(configuration.initialValue());
    }

    public static CounterValue newCounterValue(long currentValue, CounterConfiguration configuration) {
        return configuration.type() == CounterType.BOUNDED_STRONG ? CounterValue.newCounterValue(currentValue, configuration.lowerBound(), configuration.upperBound()) : CounterValue.newCounterValue(currentValue);
    }

    @ProtoField(number=1, defaultValue="0")
    public long getValue() {
        return this.value;
    }

    @ProtoField(value=2)
    public CounterState getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterValue that = (CounterValue)o;
        return this.value == that.value && this.state == that.state;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + this.state.hashCode();
        return result;
    }

    public String toString() {
        return "CounterValue{value=" + this.value + ", state=" + this.state + '}';
    }
}

