/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import io.quarkus.runtime.Quarkus;
import io.smallrye.config.ConfigValue;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import picocli.CommandLine;

@CommandLine.Command(name="show-config", header={"Print out the current configuration."}, description={"%nPrint out the current configuration."})
public final class ShowConfig
extends AbstractCommand
implements Runnable {
    public static final String NAME = "show-config";
    @CommandLine.Parameters(paramLabel="filter", defaultValue="none", description={"Show all configuration options. Use 'all' to show all options."})
    String filter;

    @Override
    public void run() {
        System.setProperty("kc.show.config", this.filter);
        String configArgs = System.getProperty("kc.show.config");
        if (configArgs != null) {
            Map<String, Set<String>> properties = ShowConfig.getPropertiesByGroup();
            String profile = ShowConfig.getProfile();
            this.printRunTimeConfig(properties, profile);
            if (configArgs.equalsIgnoreCase("all")) {
                this.printAllProfilesConfig(properties, profile);
                this.spec.commandLine().getOut().println("Quarkus Configuration:");
                properties.get("quarkus").stream().sorted().forEachOrdered(this::printProperty);
            }
            if (!Boolean.getBoolean("kc.show.config.runtime")) {
                Quarkus.asyncExit((int)0);
            }
        }
    }

    private void printRunTimeConfig(Map<String, Set<String>> properties, String profile) {
        HashSet uniqueNames = new HashSet();
        this.spec.commandLine().getOut().printf("Current Profile: %s%n", profile == null ? "none" : profile);
        this.spec.commandLine().getOut().println("Runtime Configuration:");
        properties.get("kc").stream().sorted().filter(name -> {
            String canonicalFormat = PropertyMappers.canonicalFormat(name);
            if (!canonicalFormat.equals(name)) {
                return uniqueNames.add(canonicalFormat);
            }
            return uniqueNames.add(name);
        }).forEachOrdered(this::printProperty);
    }

    private void printAllProfilesConfig(Map<String, Set<String>> properties, String profile) {
        Set<String> profiles = properties.get("%");
        if (profiles != null) {
            profiles.stream().sorted().collect(Collectors.groupingBy(s -> s.substring(1, s.indexOf(46)))).forEach((p, properties1) -> {
                if (p.equals(profile)) {
                    this.spec.commandLine().getOut().printf("Profile \"%s\" Configuration (%s):%n", p, "current");
                } else {
                    this.spec.commandLine().getOut().printf("Profile \"%s\" Configuration:%n", p);
                }
                properties1.stream().sorted().forEachOrdered(this::printProperty);
            });
        }
    }

    private static String getProfile() {
        String profile = Environment.getProfile();
        if (profile == null) {
            return Configuration.getBuildTimeProperty("quarkus.profile").orElse(null);
        }
        return profile;
    }

    private static Map<String, Set<String>> getPropertiesByGroup() {
        final Map<String, Set<String>> properties = StreamSupport.stream(Configuration.getPropertyNames().spliterator(), false).filter(ShowConfig::filterByGroup).collect(Collectors.groupingBy(ShowConfig::groupProperties, Collectors.toSet()));
        StreamSupport.stream(Configuration.getPropertyNames().spliterator(), false).filter(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                ConfigValue configValue = Configuration.getConfigValue(s);
                if (configValue == null) {
                    return false;
                }
                return "PersistedConfigSource".equals(configValue.getConfigSourceName());
            }
        }).filter(ShowConfig::filterByGroup).collect(Collectors.groupingBy(ShowConfig::groupProperties, Collectors.toSet())).forEach(new BiConsumer<String, Set<String>>(){

            @Override
            public void accept(String group, Set<String> propertyNames) {
                properties.computeIfAbsent(group, name -> new HashSet()).addAll(propertyNames);
            }
        });
        return properties;
    }

    private void printProperty(String property) {
        String canonicalFormat = PropertyMappers.canonicalFormat(property);
        ConfigValue configValue = Configuration.getConfigValue(canonicalFormat);
        if (configValue.getValue() == null) {
            configValue = Configuration.getConfigValue(property);
        }
        if (configValue.getValue() == null) {
            return;
        }
        if (configValue.getSourceName() == null) {
            return;
        }
        this.spec.commandLine().getOut().printf("\t%s =  %s (%s)%n", configValue.getName(), PropertyMappers.formatValue(configValue.getName(), configValue.getValue()), configValue.getConfigSourceName());
    }

    private static String groupProperties(String property) {
        if (property.startsWith("%")) {
            return "%";
        }
        int endIndex = property.indexOf(46);
        if (endIndex == -1) {
            return "";
        }
        return property.substring(0, endIndex);
    }

    private static boolean filterByGroup(String property) {
        return property.startsWith("kc") || property.startsWith("quarkus") || property.startsWith("%");
    }
}

