/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client.secretengine;

import io.quarkus.vault.runtime.client.VaultInternalBase;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKICRLRotateResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKICertificateListResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKICertificateResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigCABody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigCRLData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigCRLResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigURLsData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIConfigURLsResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateCertificateBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateCertificateResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateIntermediateCSRBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateIntermediateCSRResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateRootBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIGenerateRootResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRevokeCertificateBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRevokeCertificateResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRoleOptionsData;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRoleReadResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKIRolesListResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKISetSignedIntermediateCABody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKISignCertificateRequestBody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKISignCertificateRequestResult;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKISignIntermediateCABody;
import io.quarkus.vault.runtime.client.dto.pki.VaultPKITidyBody;
import io.vertx.mutiny.core.buffer.Buffer;
import javax.inject.Singleton;

@Singleton
public class VaultInternalPKISecretEngine
extends VaultInternalBase {
    private String getPath(String mount, String path) {
        return mount + "/" + path;
    }

    public Buffer getCertificateAuthority(String token, String mount, String format) {
        return this.getRaw(token, mount, "ca", format);
    }

    public Buffer getCertificateRevocationList(String token, String mount, String format) {
        return this.getRaw(token, mount, "crl", format);
    }

    public Buffer getCertificateAuthorityChain(String token, String mount) {
        return this.getRaw(token, mount, "ca_chain", null);
    }

    private Buffer getRaw(String token, String mount, String path, String format) {
        Object suffix = format != null ? "/" + format : "";
        return this.vaultClient.get(this.getPath(mount, path + (String)suffix), token);
    }

    public VaultPKICertificateResult getCertificate(String token, String mount, String serial) {
        return this.vaultClient.get(this.getPath(mount, "cert/" + serial), token, VaultPKICertificateResult.class);
    }

    public VaultPKICertificateListResult listCertificates(String token, String mount) {
        return this.vaultClient.list(this.getPath(mount, "certs"), token, VaultPKICertificateListResult.class);
    }

    public void configCertificateAuthority(String token, String mount, VaultPKIConfigCABody body) {
        this.vaultClient.post(this.getPath(mount, "config/ca"), token, (Object)body, 204);
    }

    public VaultPKICRLRotateResult rotateCertificateRevocationList(String token, String mount) {
        return this.vaultClient.get(this.getPath(mount, "crl/rotate"), token, VaultPKICRLRotateResult.class);
    }

    public VaultPKIGenerateCertificateResult generateCertificate(String token, String mount, String role, VaultPKIGenerateCertificateBody body) {
        return this.vaultClient.post(this.getPath(mount, "issue/" + role), token, (Object)body, VaultPKIGenerateCertificateResult.class);
    }

    public VaultPKISignCertificateRequestResult signCertificate(String token, String mount, String role, VaultPKISignCertificateRequestBody body) {
        return this.vaultClient.post(this.getPath(mount, "sign/" + role), token, (Object)body, VaultPKISignCertificateRequestResult.class);
    }

    public VaultPKIRevokeCertificateResult revokeCertificate(String token, String mount, VaultPKIRevokeCertificateBody body) {
        return this.vaultClient.post(this.getPath(mount, "revoke"), token, (Object)body, VaultPKIRevokeCertificateResult.class);
    }

    public void updateRole(String token, String mount, String role, VaultPKIRoleOptionsData body) {
        this.vaultClient.post(this.getPath(mount, "roles/" + role), token, (Object)body, 204);
    }

    public VaultPKIRoleReadResult readRole(String token, String mount, String role) {
        return this.vaultClient.get(this.getPath(mount, "roles/" + role), token, VaultPKIRoleReadResult.class);
    }

    public VaultPKIRolesListResult listRoles(String token, String mount) {
        return this.vaultClient.list(this.getPath(mount, "roles"), token, VaultPKIRolesListResult.class);
    }

    public void deleteRole(String token, String mount, String role) {
        this.vaultClient.delete(this.getPath(mount, "roles/" + role), token, 204);
    }

    public VaultPKIGenerateRootResult generateRoot(String token, String mount, String type, VaultPKIGenerateRootBody body) {
        return this.vaultClient.post(this.getPath(mount, "root/generate/" + type), token, (Object)body, VaultPKIGenerateRootResult.class);
    }

    public void deleteRoot(String token, String mount) {
        this.vaultClient.delete(this.getPath(mount, "root"), token, 204);
    }

    public VaultPKISignCertificateRequestResult signIntermediateCA(String token, String mount, VaultPKISignIntermediateCABody body) {
        return this.vaultClient.post(this.getPath(mount, "root/sign-intermediate"), token, (Object)body, VaultPKISignCertificateRequestResult.class);
    }

    public VaultPKIGenerateIntermediateCSRResult generateIntermediateCSR(String token, String mount, String type, VaultPKIGenerateIntermediateCSRBody body) {
        return this.vaultClient.post(this.getPath(mount, "intermediate/generate/" + type), token, (Object)body, VaultPKIGenerateIntermediateCSRResult.class);
    }

    public void setSignedIntermediateCA(String token, String mount, VaultPKISetSignedIntermediateCABody body) {
        this.vaultClient.post(this.getPath(mount, "intermediate/set-signed"), token, (Object)body, 204);
    }

    public void tidy(String token, String mount, VaultPKITidyBody body) {
        this.vaultClient.post(this.getPath(mount, "tidy"), token, (Object)body, 202);
    }

    public void configURLs(String token, String mount, VaultPKIConfigURLsData body) {
        this.vaultClient.post(this.getPath(mount, "config/urls"), token, (Object)body, 204);
    }

    public VaultPKIConfigURLsResult readURLs(String token, String mount) {
        return this.vaultClient.get(this.getPath(mount, "config/urls"), token, VaultPKIConfigURLsResult.class);
    }

    public void configCRL(String token, String mount, VaultPKIConfigCRLData body) {
        this.vaultClient.post(this.getPath(mount, "config/crl"), token, (Object)body, 204);
    }

    public VaultPKIConfigCRLResult readCRL(String token, String mount) {
        return this.vaultClient.get(this.getPath(mount, "config/crl"), token, VaultPKIConfigCRLResult.class);
    }
}

